<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the topmenu and toolbar blocks.
 *
 * -------------------------------------------------------------------------
 */

?><header class="menu"><?php

    /**
     * ---------------------------------------------------------------------
     *
     * Get a map of the topmenu items.
     *
     * ---------------------------------------------------------------------
     */

    $map = $app->has->menu
           ?    $app->menu->getMap ( )
           :    [ ];

    /**
     * ---------------------------------------------------------------------
     *
     * How to arrange root menu items?
     *
     * ---------------------------------------------------------------------
     */

    $map = array_merge ( [ 'file' => NULL ,
                           'view' => NULL ,
                           'help' => NULL ], $map );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate HTML markup.
     *
     * ---------------------------------------------------------------------
     */

    helperDisplayMenu ( $map );

?></header>
<aside class="toolbar"><?php

    /**
     * ---------------------------------------------------------------------
     *
     * Generate HTML markup.
     *
     * ---------------------------------------------------------------------
     */

    $map2 = $app->has->toolbars
            ?    $app->toolbars->getMap ( )
            :    [ ];

    $map2 = array_merge ( [ 'file' => NULL ,
                            'view' => NULL ,
                            'help' => NULL ], $map2 );

    helperDisplayMenu ( $map,  TRUE );
    helperDisplayMenu ( $map2, TRUE );

?></aside>