<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the "Log In" page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $login = '';
    $error = '';

    if ( getFormInput ( 'submit' ) ) {
        $login = getFormInput ( 'login' );
        if ( $login ) {
            $pass = getFormInput ( 'pass' );

            if ( helperLoginUser ( $login, $pass ) ) {
                echo '<script>'                       .
                         'window.location.reload ( )' .
                     '</script>';
                return;

            } else {
                $error = 'Unfortunately, this login or its password is incorrect.';
            }
        } else {
            $error = 'The Login field below is required.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

?>  <div class="modal notification">
        <div class="error"><?php printValue ( $error ) ?></div>

        <!--
         * -----------------------------------------------------------------
         *
         * Form for a regular visitor.
         *
         * -----------------------------------------------------------------
         -->

        <details class="form" open>
            <summary>
                <span>I want to run a project</span>
                <span>I am a developer</span>
            </summary>
            <h1>Welcome</h1>
            <p>Select a project to run it.</p>
            <label>
                <small>Project</small>
                <select name="project">
                    <?php
                        $list = helperListProjects ( );
                        foreach ( $list as $lowercase => $directory ) {
                            ?>
                            <option value="projects/<?php printValue ( $lowercase ) ?>">
                                <?php printValue ( $directory ) ?>
                            </option>
                            <?php
                        }
                    ?>
                </select>
            </label>
            <footer class="buttons">
                <button class="btn" onclick="app.runProject ( this )">RUN</button>
            </footer>
        </details>

        <!--
         * -----------------------------------------------------------------
         *
         * Form for logging in as a developer.
         *
         * -----------------------------------------------------------------
         -->

        <form class="form" method="post">
            <h1>IDE panel</h1>
            <p>Log in to develop projects.</p>
            <label>
                <small>Login</small>
                <input type="text" name="login" value="<?php printValue ( $login ) ?>" max-length="50" required>
                <small>In demo mode, you may use login <b>demo</b> and password <b>demo</b></small>
            </label>
            <label>
                <small>Password</small>
                <input type="password" name="pass" value="" max-length="50" required>
            </label>
            <footer class="buttons">
                <button class="btn" type="submit" name="submit" value="1">LOG IN</button>
            </footer>
        </form>
    </div>
