<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module to request projects you have developed.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiProjects extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * RegExp pattern to validate the project file extensions.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access public
         *
         * -----------------------------------------------------------------
         */

        public $editorExtensions = 'tpl|html|htm|xml|js|json|css|txt|php|svg';
        public $viewerExtensions = 'png|jpeg|jpg|gif|ico|webp|mp3|ogg|wav|weba|mp4|webm|otf|ttf|woff|woff2';

        /**
         * -----------------------------------------------------------------
         *
         * Renders a project page associated with the clicked URL.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  The URL that was clicked.
         * @return  bool          TRUE  if the page was rendered successfully.
         *                        FALSE if there is no such project.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $url = '' ) {
            if ( $url != '' ) {
                $root = MIMIMI_APP_FOLDER;
                $path = '';
                $name = 'Projects';
                $segments = preg_split  ( '~/~u', $url );
                do {
                    $path .= $name . '/';
                    $name  = array_shift ( $segments );
                    $names = mimimiFolders ( $root . $path );
                    $index = mb_strtolower ( $name, 'UTF-8' );
                    $ok    = isset ( $names[ $index ] );
                    if ( $ok ) $name = $names[ $index ];
                } while ( $ok && $segments );
                if ( ! $segments ) {
                    $base = mimimiBasePath ( );
                    $file = $path . $name;
                    if ( ! file_exists ( $base . $root . $file )
                    ||   ! is_file     ( $base . $root . $file ) ) {
                        $file .= ( $ok ? '/index' : '' ) . '.tpl';
                        if ( ! file_exists ( $base . $root . $file )
                        ||   ! is_file     ( $base . $root . $file ) ) {
                            return FALSE;
                        }
                    }
                    $pattern = '~^.*?\.(' . $this->editorExtensions . '|'
                                          . $this->viewerExtensions . ')$~ui';
                    if ( preg_match ( $pattern, $file ) ) {
                        $this->app->runModule ( 'helper' );
                        $ext = preg_replace ( $pattern, '$1', $file );
                        switch ( mb_strtolower ( $ext, 'UTF-8' ) ) {
                            case 'tpl':
                            case 'php':   mimimiInclude ( $file, FALSE );
                                          return TRUE;
                            case 'htm':
                            case 'html':  sendHeaderHTML ( ); break;
                            case 'xml':   sendHeaderXML  ( ); break;
                            case 'css':   sendHeaderCSS  ( ); break;
                            case 'js':    sendHeaderJS   ( ); break;
                            case 'json':  sendHeaderJSON ( ); break;
                            case 'txt':   sendHeaderTEXT ( ); break;
                            case 'svg':   @ header ( 'Content-Type: image/svg+xml', TRUE ); break;
                            case 'png':   @ header ( 'Content-Type: image/png',     TRUE ); break;
                            case 'jpg':
                            case 'jpeg':  @ header ( 'Content-Type: image/jpeg',    TRUE ); break;
                            case 'gif':   @ header ( 'Content-Type: image/gif',     TRUE ); break;
                            case 'ico':   @ header ( 'Content-Type: image/x-icon',  TRUE ); break;
                            case 'webp':  @ header ( 'Content-Type: image/webp',    TRUE ); break;
                            case 'mp3':   @ header ( 'Content-Type: audio/mpeg',    TRUE ); break;
                            case 'ogg':   @ header ( 'Content-Type: audio/ogg',     TRUE ); break;
                            case 'wav':   @ header ( 'Content-Type: audio/x-wav',   TRUE ); break;
                            case 'weba':  @ header ( 'Content-Type: audio/webm',    TRUE ); break;
                            case 'mp4':   @ header ( 'Content-Type: video/mp4',     TRUE ); break;
                            case 'webm':  @ header ( 'Content-Type: video/webm',    TRUE ); break;
                            case 'otf':   @ header ( 'Content-Type: font/otf',      TRUE ); break;
                            case 'ttf':   @ header ( 'Content-Type: font/ttf',      TRUE ); break;
                            case 'woff':  @ header ( 'Content-Type: font/woff',     TRUE ); break;
                            case 'woff2': @ header ( 'Content-Type: font/woff2',    TRUE ); break;
                        }
                        sendStatus200 ( );
                        readfile ( $base . $root . $file );
                        return TRUE;
                    }
                }
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns data for the project the user is currently developing.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  array
         *
         * -----------------------------------------------------------------
         */

        public function getProject ( ) {
            $data = $this->app->session->get ( 'userProject', [ ] );
            return array_merge ( [ 'dir'      => '',
                                   'modified' => FALSE,
                                   'files'    => [ ] ], (array) $data );
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns a list of files that the user is currently editing.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  array  List of file names relative to the current project directory.
         *
         * -----------------------------------------------------------------
         */

        public function getFiles ( ) {
            $data = $this->getProject ( );
            return ! empty ( $data[ 'files' ] )
                           ? $data[ 'files' ]
                           : [ ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns the current user's entry.
         *
         * -----------------------------------------------------------------
         *
         * Please note that in demo mode, any visitor is considered Admin 1
         * if he/she visits your site for the first time. That is, he/she
         * enters the dashboard for the first time without authorization.
         * However, if he/she logs out, next time authorization will be
         * required regardless of the demo mode.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  array  The entry of the currently logged in user.
         *
         * -----------------------------------------------------------------
         */

        public function getUser ( ) {
            $default = [ 'id' => 0 ];
            $param   = 'userInfo';
            if ( ! $this->app->onProduction ) {
                $demo  = [ 'id' => 1 ];
                $entry = $this->app->session->get ( $param, $demo  );
                         $this->app->session->set ( $param, $entry );
                return $entry;
            }
            return $this->app->session->get ( $param, $default );
        }
    };
