<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module to request pages attached to the "View" submenu.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Collection.php' );

    class MyMimimiMenuView extends MimimiCollection {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the "View" menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            return [ 'view' => [ 'name'     => 'View',
                                 'subitems' => [ 'preview'     => NULL ,
                                                 'full_screen' => NULL ] ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         * @return  bool             Always FALSE, meaning there is no page for this item.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Reset the namespace simulator if you want to provide an ability
         * to extend this menu with submenu items using child modules.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    };
