<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a vendor page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = database entry retrieved by the "Vendors" module
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML ( );
    sendStatus200  ( );
    stopIfHead     ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="<?php printValue ( $params[ 'lang' ] ) ?>">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">

        <meta name="robots" content="index, follow">
        <title>
            <?php printValue ( $params[ 'brand' ] ) ?>
        </title>
        <meta name="description" content="<?php printValue ( $params[ 'meta' ] ) ?>">

        <!--
         * -----------------------------------------------------------------
         *
         * Pay attention to the "data-url" and "data-logo" attributes of
         * this tag. They are used in the Vue template, which is referenced
         * below.
         *
         * -----------------------------------------------------------------
         -->

        <link rel="canonical" href="<?php      printPageUrl (                   ) ?>"
                              data-url="<?php  printValue   ( $params[ 'url'  ] ) ?>"
                              data-logo="<?php printValue   ( $params[ 'logo' ] ) ?>">
    </head>

    <body>
        <div id="app"></div>

        <!--
         * -----------------------------------------------------------------
         *
         * Load the Vue template file corresponding to the current page into
         * a Javascript variable.
         *
         * -----------------------------------------------------------------
         -->

        <script>
            const vueTemplate = `<?php
                                     $body = $app->helper->readVue ( 'snippets/shopping-ui.vue' );
                                     echo    $app->helper->asTemplateLiteral ( $body );
                                 ?>`;
        </script>

        <!--
         * -----------------------------------------------------------------
         *
         * Connect the private Javascripts needed for this Vue template
         * to work.
         *
         * -----------------------------------------------------------------
         -->

        <script src="<?php printThemeUrl ( ) ?>js/axios.min.js"></script>
        <script src="<?php printThemeUrl ( ) ?>js/gsap.min.js"></script>

        <!--
         * -----------------------------------------------------------------
         *
         * Connect and run the Javascripts needed to launch any Vue template
         * on the browser side without Node.js server-side rendering.
         *
         * -----------------------------------------------------------------
         -->

        <script src="<?php printThemeUrl ( ) ?>js/vue.runtime.global.prod.js"></script>
        <script src="<?php printThemeUrl ( ) ?>js/pug.js"></script>
        <script src="<?php printThemeUrl ( ) ?>js/vue3-sfc-loader.js"></script>
        <script>
            const vueLocalTemplateUsed = '/no.vue',
                  vueTemplateUrl       = vueLocalTemplateUsed,

                  { loadModule } = window[ 'vue3-sfc-loader' ],

                  vueOptions = {
                      moduleCache: {
                          vue: Vue,
                          pug: require( 'pug' )
                      },

                      getFile ( url ) {
                          if ( url == vueLocalTemplateUsed ) {
                              return Promise.resolve ( vueTemplate );
                          }
                      },

                      addStyle ( rules ) {
                          const head = document.head,
                                name = 'style',
                                node = head.getElementsByTagName ( name )[ 0 ] || null,
                                tag  = document.createElement ( name );
                          tag.textContent = rules;
                          head.insertBefore ( tag, node );
                      }
                  };

            Vue.createApp (
                Vue.defineAsyncComponent (
                    ( ) => loadModule ( vueTemplateUrl, vueOptions )
                )
            ) .mount ( '#app' );
        </script>
    </body>
</html>