<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering an order page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = database entries retrieved by the "Orders" module
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML    (   );
    sendStatus200     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Get the first row in that order entries.
     *
     * ---------------------------------------------------------------------
     *
     * I would like to point out that the "orders" database table implements
     * a non-standard order numbering scheme. The order number is equated to
     * ID of the first row in the list of ordered items, so when retrieving
     * an order, its rows are sorted by "orders.id" column.
     *
     * Therefore, next I copy the first row from $params variable, which
     * contains the product entries for the current order, into local
     * variable $order. This will make it easier for me to display below any
     * information that related to the order itself, rather than its items.
     *
     * ---------------------------------------------------------------------
     */

    $order = reset ( $params );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     *
     * Please note that all elements with <small> tag are used with
     * pseudo-state ":empty" in mind, meaning that there should be no
     * trailing whitespace when they are generated.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="noindex, nofollow">
        <title>
            Order #<?php printValue ( $order[ 'id' ] ) ?>
        </title>
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    <small data-label="Buyer: "><?php    printValue ( $order[ 'customer' ] ) ?></small>
                    <small data-label="Delivery: "><?php printValue ( $order[ 'address'  ] ) ?></small>
                </div>

                <h1 class="title">
                    Order #<?php printValue ( $order[ 'id'   ] ) ?>
                    <small><?php printValue ( $order[ 'date' ] ) ?></small>
                </h1>

                <div class="shop-items">
                    <div class="item">
                        <div class="item-block">
                            <?php
                                $total = 0;
                                foreach ( $params as $entry ) {
                                    $price  = $entry[ 'cost'  ];
                                    $count  = $entry[ 'count' ];
                                    $total += $price * $count;
                                    ?>
                                    <h2 class="name tr">
                                        <small><?php printValue ( $entry[ 'vendor'  ] ) ?></small>
                                        <?php        printValue ( $entry[ 'product' ] ) ?>
                                    </h2>
                                    <nav class="bottom-area">
                                        <div class="price gray">
                                            $<?php printValue ( round ( $price, 2 ) ) ?>
                                        </div>
                                        <div class="amount">
                                            <?php  printValue ( $count ) ?>
                                        </div>
                                    </nav>
                                    <?php
                                }
                            ?>

                            <small data-label="Closed: "><?php printValue ( $order[ 'closed' ] ) ?></small>

                            <nav class="bottom-area hr">
                                <div class="price">
                                    $<?php printValue ( round ( $total, 2 ) ) ?>
                                </div>
                                <a class="button" href="<?php printSiteUrl ( ) ?>">
                                    <p>GO TO HOME</p>
                                </a>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>