/**
 * -------------------------------------------------------------------------
 *
 * Scripts for the client side of your website.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

function standardFix ( url ) {
    return url.replace( /(^\s+|\s+$)/g,       ''  )
              .replace( /[\/\\\\]+/g,         '/' )
              .replace( /[^\w:\/_.]+/g,       '-' )
              .replace( /\.+/g,               '.' )
              .replace( /\.+\/+/g,            '/' )
              .replace( /\/+\.+/g,            '/' )
              .replace( /\/+/g,               '/' )
              .replace( /(^[\/.]+|[\/.]+$)/g, ''  );
};

/**
 * -------------------------------------------------------------------------
 *
 * Handles the input box "Page URL:" ( see file  tiny.news.feed/Themes/default/snippets/form-news.tpl -> input with name "url" -> onblur ).
 *
 * -------------------------------------------------------------------------
 */

function correctPageUrl () {
    let input = event.target,
        url   = input.value;

    url = standardFix(url)
          .replace( /[\-.]+/g,                                 '-' )
          .replace( /\/+(add|edit|delete|sitemap|page-\d+)$/i, ''  );

    input.value = url;
};

/**
 * -------------------------------------------------------------------------
 *
 * Handles the input box "Image URL:" ( see file  tiny.news.feed/Themes/default/snippets/form-news.tpl -> input with name "image" -> onblur ).
 *
 * -------------------------------------------------------------------------
 */

function correctImageUrl () {
    let input = event.target,
        url   = input.value;

    url = standardFix(url)
          .replace( /^:\/+/i, 'https://' );

    if ( url != '' ) {
        if ( url.search(/^media\//)  == -1
        &&   url.search(/^[a-z]+:/i) == -1 ) {
            url = 'media/' + url;
        }
    }

    input.value = url;
};
