<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a STEP-2 page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     if page STEP-1 is not passed
     *         redirect to homepage
     *     remember that page STEP-2 is not passed
     *     ............. page STEP-3 is not passed
     *     ............. page STEP-4 is not passed
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    if ( hasNoCheckpoint ( 'step1' ) ) {
        gotoHome ( );
    }
    clearCheckpoint ( 'step2' );
    clearCheckpoint ( 'step3' );
    clearCheckpoint ( 'step4' );

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title' => 'Install the MiMiMi - Theme',
                'meta'  => 'This is an installer page to choose theme for components.',
                'h1'    => 'Choose the themes'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1>
            <strong>Step 2 of 4</strong>
            <?php printPageH1 ( ) ?>
        </h1>
        <p>You need to specify the frontend theme for each component. It is one of the themes located in the <em>Themes</em> folder of the corresponding component.</p>
        <?php mimimiModule ( 'blocks/form-2.tpl' ) ?>
    </main>
    <?php mimimiModule ( 'blocks/footer.tpl' ) ?>
