<?php
/**
 * -------------------------------------------------------------------------
 *
 * The viewer module for displaying a page at an incorrect URL. It is always
 * called using run() method implemented below. The initiator of that call
 * is the main module of your application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Fellowship site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );
    class MyMimimiError404 extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Displays the contents of error page.
         *
         * -----------------------------------------------------------------
         *
         * This method handles the following URLs:
         *
         *     https://your.site/UNDEFINED-URL
         *                       │           │
         *                       └────┬──────┘
         *                            │
         *                            └─> it is the incoming $params
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) The relative page URL as discovered by the app's routing method.
         * @return  bool            TRUE if the page was rendered successfully.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $this->app->renderTemplate ( 'error-404.tpl',
                                                'Oops, this site does not have a template for Error 404 case!' );
        }
    };
