<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's STEP-1 page     |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > if page HOME is not passed       |
    |           > redirect to homepage         |
    |       > end if                           |
    |       > remember that STEP-1 isn't passed|
    |       > ... page STEP-2 is not passed    |
    |       > ... page STEP-3 is not passed    |
    |       > ... page STEP-4 is not passed    |
    |       > ... page STEP-5 is not passed    |
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    if (hasNoCheckpoint('home')) {
        gotoHome();
    }
    clearCheckpoint('step1');
    clearCheckpoint('step2');
    clearCheckpoint('step3');
    clearCheckpoint('step4');
    clearCheckpoint('step5');
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Directories',
                'meta'     => 'This is an installer page to choose folders for installation.',
                'keywords' => 'directories page, choose installation directories',
                'h1'       => 'Choose the directories'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

    /* -----------------------------------------
    |                                          |
    |   Display the page's top                 |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/header.php');

?>  <!-- ---------------------------------------
    |                                          |
    |   Display the page's content             |
    |                                          |
    ---------------------------------------- -->

    <main>
        <h1>
            <strong>Step 1 of 5</strong>
            <?php printPageH1() ?>
        </h1>

        <p>
            You need to select the directories where the required
            framework components will be installed.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   Display the form named FORM-1      |
        |                                      |
        ------------------------------------ -->

        <?php mimimiModule('blocks/form-1.php'); ?>
    </main>

<?php /* ---------------------------------------
    |                                          |
    |   Display the page's bottom              |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/footer.php');