<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's home page       |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > remember that page HOME is passed|
    |       > ... page STEP-1 is not passed    |
    |       > ... page STEP-2 is not passed    |
    |       > ... page STEP-3 is not passed    |
    |       > ... page STEP-4 is not passed    |
    |       > ... page STEP-5 is not passed    |
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    setCheckpoint('home');
    clearCheckpoint('step1');
    clearCheckpoint('step2');
    clearCheckpoint('step3');
    clearCheckpoint('step4');
    clearCheckpoint('step5');
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Welcome',
                'meta'     => 'This is a welcome page of the framework installer.',
                'keywords' => 'welcome page, how install framework',
                'h1'       => 'Welcome to the Installer!'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

        /* -------------------------------------
        |                                      |
        |   Display the page's top             |
        |                                      |
        ------------------------------------- */

        mimimiModule('blocks/header.php');

?>      <!-- -----------------------------------
        |                                      |
        |   Display the page's content         |
        |                                      |
        ------------------------------------ -->

        <main>
            <h1><?php printPageH1() ?></h1>

            <p>
                It will allow you to go through the installation process
                and select the desired framework configuration.
                Installation consists of <strong>5</strong> steps:
            </p>

            <ul>
                <li>choosing the installation directory,</li>
                <li>choosing the frontend theme,</li>
                <li>choosing which modules to install,</li>
                <li>configuring database access,</li>
                <li>specifying your masters contact.</li>
            </ul>

            <hr>

            <p>
                As a result, you will install the MiMiMi framework
                (version <em><?php printValue(MIMIMI_CORE_VERSION) ?></em>)
                on your website.
            </p>

            <!-- -------------------------------
            |                                  |
            |   A remark                       |
            |                                  |
            -------------------------------- -->

            <blockquote class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-info"></use>
                </svg>

                If you are a developer, please see the
                <em><?php printValue($folder) ?>Application.php</em>
                file and its template
                <em><?php printValue($folder . $filename) ?></em>
                to understand how this installer works.
            </blockquote>

            <!-- -------------------------------
            |                                  |
            |   Pagination if you need         |
            |                                  |
            -------------------------------- -->

            <nav>
                <a class="btn" href="<?php printSiteUri() ?>step-1">
                    Next &raquo;
                </a>
            </nav>
        </main>

<?php   /* -------------------------------------
        |                                      |
        |   Display the page's bottom          |
        |                                      |
        ------------------------------------- */

        mimimiModule('blocks/footer.php');