<?php /* =======================================================
|                                                              |
|   Template to display the Error404 page                      |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > send status "404 Not Found"      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    sendStatus404();

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <title>Page not found!</title>
        <link rel="shortcut icon" href="<?php printSiteUri() ?>favicon.ico" type="image/ico">
        <style>
            <?php mimimiDump('css/style.css') ?>
        </style>
    </head>
    <body>
        <header>
            <p>This is a base application to install any components of the MiMiMi package.</p>
        </header>

        <main>
            <h1>Page not found!</h1>
            <p>Oops, something went wrong! There is no such page. Please go to the home page.</p>
            <nav>
                <a class="btn" href="<?php printSiteUri() ?>">&laquo; Home</a>
            </nav>
        </main>

        <footer>
            <p>&copy; <?php echo date('Y') ?> Installer Example</p>
            <menu>
                <a href="https://mimimi.software/" rel="nofollow">Powered by MiMiMi</a>
                <a href="https://flaticon.com/" rel="nofollow">Icons by FlatIcon</a>
            </menu>
        </footer>
    </body>
</html>