<?php /* =======================================================
|                                                              |
|   Template to display the page's form named FORM-4           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Make the DISABLED/EDITABLE attribute   |
    |   and the DISABLED/REQUIRED class for    |
    |   INPUTS (see them in the HTML layout    |
    |   below, and see the related INPUT 2     |
    |   on the STEP-1 page, and see the        |
    |   related INPUT named "modulesDb" on the |
    |   STEP-3 page)                           |
    |                                          |
    ----------------------------------------- */

    $prefix = getFlashbackPrefix();
    $param  = $prefix . 'folderModules';
    $param2 = $prefix . 'modulesDb';
    $inputAttribute  = getSession($param)
                       ? ''
                       : 'disabled';
    $inputAttribute2 = !$inputAttribute &&
                       getSession($param2)
                       ? ''
                       : 'disabled';
    $inputClass      = $inputAttribute2
                       ? 'disabled'
                       : '';
    $inputClass2     = $inputAttribute2
                       ? 'disabled'
                       : 'required';

    /* -----------------------------------------
    |                                          |
    |   Define the controlled form fields:     |
    |       name         = a field name        |
    |       value        = its initial value   |
    |       options      = list of values for  |
    |                      tag <select> in     |
    |                      format "Value" or   |
    |                      "Value|To Display"  |
    |       flashback    = TRUE if save the    |
    |                      posted field in     |
    |                      session and restore |
    |                      it on next time     |
    |       corrected    = a list of regular   |
    |                      expressions to      |
    |                      optimize the posted |
    |                      field before        |
    |                      checking for errors |
    |       required     = TRUE if the posted  |
    |                      field cannot be     |
    |                      empty               |
    |       requ..Error  = a message if this   |
    |                      field is empty      |
    |       format       = a regular expression|
    |                      to validate the     |
    |                      posted field        |
    |       formatError  = a message if this   |
    |                      field is incorrect  |
    |       cha..Message = a message if this   |
    |                      field is changed    |
    |       readonly     = TRUE if ignore this |
    |                      field and always use|
    |                      its initial value   |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: Define this variable as global   |
    |         to use below (see routines       |
    |         printFormValue, printFormError,  |
    |         and printFormChanges in the      |
    |         HELPER.PHP file).                |
    |                                          |
    ----------------------------------------- */

    global $form;
    $form = array(
        array(
            'name'           => 'databaseDriver',
            'value'          => MIMIMI_DATABASE_DRIVER,
            'options'        => array(
                                    '|[no database]',
                                    'cubrid',
                                    'dblib',
                                    'firebird',
                                    'ibm',
                                    'odbc-ibm',
                                    'informix',
                                    'mssql',
                                    'mysql',
                                    'odbc',
                                    'oci',
                                    'oracle',
                                    'pgsql',
                                    'sqlsrv',
                                    'sybase',
                                    'odbc',
                                    'odbc-access',
                                    'sqlite'
                                ),
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^a-z-]/u' => '-'
                                ),
            'format'         => '/^[a-z][a-z-]*[a-z]$/u',
            'formatError'    => 'Driver is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databaseHost',
            'value'          => MIMIMI_DATABASE_HOST,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.:a-z0-9_-]/ui' => '-',
                                    '/::+/u'            => '::',
                                    '/\.+/u'            => '.',
                                    '/:[^a-z0-9:]+/u'   => ':',
                                    '/[^a-z0-9:]+:/u'   => ':'
                                ),
            'format'         => '/^[a-z0-9:][.:a-z0-9_-]*[a-z0-9:]$/ui',
            'formatError'    => 'Host is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databasePort',
            'value'          => MIMIMI_DATABASE_PORT,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^0-9]/u' => ''
                                ),
            'format'         => '/^[0-9]{1,5}$/u',
            'formatError'    => 'Port is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databaseUser',
            'value'          => MIMIMI_DATABASE_USER,
            'flashback'      => TRUE
        ),
        array(
            'name'           => 'databasePassword',
            'value'          => MIMIMI_DATABASE_PASSWORD,
            'flashback'      => TRUE
        ),
        array(
            'name'           => 'databaseName',
            'value'          => MIMIMI_DATABASE_NAME,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^a-z0-9_]/ui' => '-'
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databasePrefix',
            'value'          => MIMIMI_DATABASE_TABLE_PREFIX,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^a-z0-9_]/ui' => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databaseCharset',
            'value'          => MIMIMI_DATABASE_CHARSET,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.:;a-z0-9_-]/ui' => '-'
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'databaseCollation',
            'value'          => MIMIMI_DATABASE_COLLATION,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.:;a-z0-9_-]/ui' => '-'
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        )
    );

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > restore (flashback) value of     |
    |         the form fields from the session |
    |       > if form is posted                |
    |           > validate posted form if      |
    |             modules are not disabled     |
    |             (see the INPUT 2 on the      |
    |             STEP-1 page) or DB module    |
    |             is not disabled (see the     |
    |             STEP-3 page)                 |
    |           > if that form is OK           |
    |               > try to connect           |
    |               > if result is OBJECT      |
    |                   > remember that STEP-4 |
    |                     is passed            |
    |                   > send soft redirect   |
    |                     to the STEP-5 page   |
    |                   > return (break this   |
    |                     template)            |
    |               > else if result is TRUE   |
    |                   > remember that STEP-4 |
    |                     is passed            |
    |                   > send soft redirect   |
    |                     to the STEP-5 page   |
    |                   > return (break this   |
    |                     template)            |
    |               > else if result is STRING |
    |                   > display a warning    |
    |                     with that string (it |
    |                     contains an error    |
    |                     text)                |
    |               > end if                   |
    |           > end if                       |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    flashbackForm($form);
    if (mimimiPost('submitForm4')) {
        $ok = $inputAttribute2
              ? 1
              : validateForm($form, 'submitForm4');
        if ($ok) {
            $ok = $ok === 1
                  ? TRUE
                  : $app->db->connect(
                        array(
                            'driver'    => getSession($prefix . 'databaseDriver'),
                            'host'      => getSession($prefix . 'databaseHost'),
                            'port'      => getSession($prefix . 'databasePort'),
                            'user'      => getSession($prefix . 'databaseUser'),
                            'password'  => getSession($prefix . 'databasePassword'),
                            'name'      => getSession($prefix . 'databaseName'),
                            'charset'   => getSession($prefix . 'databaseCharset'),
                            'collation' => getSession($prefix . 'databaseCollation')
                        )
                    );
            if (is_object($ok)) {
                setCheckpoint('step4'); ?>

                <script>
                    location.replace('<?php printSiteUri() ?>step-5')
                </script> <?php

                return;
            } else if ($ok === TRUE) {
                setCheckpoint('step4'); ?>

                <script>
                    location.replace('<?php printSiteUri() ?>step-5')
                </script> <?php

                return;
            } else if (is_string($ok)) { ?>

                <p class="warning">
                    <?php printValue($ok) ?>
                </p> <?php
            }
        }

    /* -----------------------------------------
    |                                          |
    |   Do some warning logic                  |
    |       > Otherwise (if it is first visit) |
    |           > if modules are disabled      |
    |               > display a warning        |
    |           > else if DB module is disabled|
    |               > display a warning        |
    |           > end if                       |
    |       > end if                           |
    |                                          |
    ----------------------------------------- */

    } else {
        if ($inputAttribute) { ?>

            <p class="warning">
                ATTENTION &raquo; You declined the installation of modules
                on the STEP 1 page, so these settings are not available. You can return
                <a href="<?php printSiteUri() ?>step-1">&laquo; to the STEP 1</a>
                or click the NEXT button below to continue.
            </p> <?php

        } else if ($inputAttribute2) { ?>

            <p class="warning">
                ATTENTION &raquo; You declined the installation of <em>Db</em> module
                on the STEP 3 page, so these settings are not available. You can return
                <a href="<?php printSiteUri() ?>step-3">&laquo; to the STEP 3</a>
                or click the NEXT button below to continue.
            </p> <?php
        }
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?>  <form action="<?php printPageUri() ?>" method="post">
        <fieldset>
            <legend>
                DB access parameters
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 1                     |
            |                                  |
            -------------------------------- -->

            <label class="size4 <?php printValue($inputClass) ?>">
                <span class="caption">
                    database driver:
                </span>
                <select name="databaseDriver"
                        <?php printValue($inputAttribute2) ?>>
                    <?php printFormOptions('databaseDriver') ?>
                </select>
                <span class="error"><?php printFormError('databaseDriver') ?></span>
                <span class="changed"><?php printFormChanges('databaseDriver') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 2                     |
            |                                  |
            -------------------------------- -->

            <label class="size4  <?php printValue($inputClass2) ?>">
                <span class="caption">
                    host:
                </span>
                <input name="databaseHost"
                       type="text"
                       value="<?php printFormValue('databaseHost') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databaseHost') ?></span>
                <span class="changed"><?php printFormChanges('databaseHost') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 3                     |
            |                                  |
            -------------------------------- -->

            <label class="size2 <?php printValue($inputClass) ?>">
                <span class="caption">
                    port:
                </span>
                <input name="databasePort"
                       type="number"
                       value="<?php printFormValue('databasePort') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databasePort') ?></span>
                <span class="changed"><?php printFormChanges('databasePort') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 4                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    user:
                </span>
                <input name="databaseUser"
                       type="text"
                       value="<?php printFormValue('databaseUser') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databaseUser') ?></span>
                <span class="changed"><?php printFormChanges('databaseUser') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 5                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass) ?>">
                <span class="caption">
                    password:
                </span>
                <input name="databasePassword"
                       type="password"
                       value="<?php printFormValue('databasePassword') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databasePassword') ?></span>
                <span class="changed"><?php printFormChanges('databasePassword') ?></span>
            </label>
        </fieldset>

        <fieldset>
            <legend>
                Storage parameters
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 6                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    database name:
                </span>
                <input name="databaseName"
                       type="text"
                       value="<?php printFormValue('databaseName') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databaseName') ?></span>
                <span class="changed"><?php printFormChanges('databaseName') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 7                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass) ?>">
                <span class="caption">
                    table prefix:
                </span>
                <input name="databasePrefix"
                       type="text"
                       value="<?php printFormValue('databasePrefix') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databasePrefix') ?></span>
                <span class="changed"><?php printFormChanges('databasePrefix') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 8                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass) ?>">
                <span class="caption">
                    charset:
                </span>
                <input name="databaseCharset"
                       type="text"
                       value="<?php printFormValue('databaseCharset') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databaseCharset') ?></span>
                <span class="changed"><?php printFormChanges('databaseCharset') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 9                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass) ?>">
                <span class="caption">
                    collation:
                </span>
                <input name="databaseCollation"
                       type="text"
                       value="<?php printFormValue('databaseCollation') ?>"
                       <?php printValue($inputAttribute2) ?>>
                <span class="error"><?php printFormError('databaseCollation') ?></span>
                <span class="changed"><?php printFormChanges('databaseCollation') ?></span>
            </label>
        </fieldset>

        <!-- -----------------------------------
        |                                      |
        |   A remark                           |
        |                                      |
        ------------------------------------ -->

        <blockquote class="iconized">
            <svg class="icon">
                <use xlink:href="#icon-info"></use>
            </svg>

            Required fields are marked with a red dot in the corner.
            In case of an input error, a red warning will appear under
            the wrong field. If a field is corrected by the Installer,
            a green notice will appear under that field.
        </blockquote>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>step-3">
                &laquo; Back
            </a>
            <button type="submit" name="submitForm4" value="1">
                Next &raquo;
            </button>
        </nav>
    </form>
