<?php /* =======================================================
|                                                              |
|   Template to display the page's form named FORM-1           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Define the controlled form fields:     |
    |       name         = a field name        |
    |       value        = its initial value   |
    |       options      = list of values for  |
    |                      tag <select> in     |
    |                      format "Value" or   |
    |                      "Value|To Display"  |
    |       flashback    = TRUE if save the    |
    |                      posted field in     |
    |                      session and restore |
    |                      it on next time     |
    |       corrected    = a list of regular   |
    |                      expressions to      |
    |                      optimize the posted |
    |                      field before        |
    |                      checking for errors |
    |       required     = TRUE if the posted  |
    |                      field cannot be     |
    |                      empty               |
    |       requ..Error  = a message if this   |
    |                      field is empty      |
    |       format       = a regular expression|
    |                      to validate the     |
    |                      posted field        |
    |       formatError  = a message if this   |
    |                      field is incorrect  |
    |       cha..Message = a message if this   |
    |                      field is changed    |
    |       readonly     = TRUE if ignore this |
    |                      field and always use|
    |                      its initial value   |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: Define this variable as global   |
    |         to use below (see routines       |
    |         printFormValue, printFormError,  |
    |         and printFormChanges in the      |
    |         HELPER.PHP file).                |
    |                                          |
    ----------------------------------------- */

    global $form;
    $form = array(
        array(
            'name'           => 'folderCore',
            'value'          => MIMIMI_CORE_FOLDER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[\s.]*[\/\\\\]+/u' => '/',
                                    '/[\/\\\\]+\s+/u'    => '/',
                                    '/\.+/u'             => '.',
                                    '/[^.a-z0-9_\/]+/ui' => '-',
                                    '/^\/+([^\/])/u'     => '$1',
                                    '/([^\/])$/u'        => '$1/'
                                ),
            'required'       => TRUE,
            'requiredError'  => 'This component is required!',
            'format'         => '/^[a-z0-9_-]([.a-z0-9_-]*[a-z0-9_-])?\/$/ui',
            'formatError'    => 'Directory name is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'folderModules',
            'value'          => MIMIMI_MODULES_FOLDER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[\s.]*[\/\\\\]+/u' => '/',
                                    '/[\/\\\\]+\s+/u'    => '/',
                                    '/\.+/u'             => '.',
                                    '/[^.a-z0-9_\/]+/ui' => '-',
                                    '/^\/+([^\/])/u'     => '$1',
                                    '/([^\/])$/u'        => '$1/'
                                ),
            'format'         => '/^[a-z0-9_-]([.a-z0-9_-]*[a-z0-9_-])?\/$/ui',
            'formatError'    => 'Directory name is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'folderApp',
            'value'          => MIMIMI_APP_FOLDER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[\s.]*[\/\\\\]+/u' => '/',
                                    '/[\/\\\\]+\s+/u'    => '/',
                                    '/\.+/u'             => '.',
                                    '/[^.a-z0-9_\/]+/ui' => '-',
                                    '/^\/+([^\/])/u'     => '$1',
                                    '/([^\/])$/u'        => '$1/'
                                ),
            'format'         => '/^[a-z0-9_-]([.a-z0-9_-]*[a-z0-9_-])?\/$/ui',
            'formatError'    => 'Directory name is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'folderAppVariant',
            'value'          => preg_replace('/[\/\\\\]+$/u', '', MIMIMI_APP_FOLDER),
            'options'        => listAppVariants(),
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.a-z0-9_-]+/ui' => '-',
                                    '/\.+/u'            => '.',
                                    '/\.+$/u'           => ''
                                ),
            'format'         => '/^[.a-z0-9_-]+$/ui',
            'formatError'    => 'Variant is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'folderInstall',
            'value'          => MIMIMI_INSTALL_FOLDER,
            'readonly'       => TRUE
        )
    );

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > restore (flashback) value of     |
    |         the form fields from the session |
    |       > validate posted form             |
    |       > if that form is OK               |
    |           > remember "STEP-1 is passed"  |
    |           > send soft redirect to STEP-2 |
    |           > return (break this template) |
    |       > end if                           |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    flashbackForm($form);
    $ok = validateForm($form, 'submitForm1');
    if ($ok) {
        setCheckpoint('step1'); ?>

        <script>
            location.replace('<?php printSiteUri() ?>step-2')
        </script> <?php

        return;
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?>  <form action="<?php printPageUri() ?>" method="post">
        <fieldset>
            <legend>
                Installation directories
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 1                     |
            |                                  |
            -------------------------------- -->

            <label class="size33 required">
                <span class="caption">
                    for the Core:
                </span>
                <input name="folderCore"
                       type="text"
                       value="<?php printFormValue('folderCore') ?>">
                <span class="error"><?php printFormError('folderCore') ?></span>
                <span class="changed"><?php printFormChanges('folderCore') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 2                     |
            |                                  |
            -------------------------------- -->

            <label class="size33">
                <span class="caption">
                    for the Core's modules:
                </span>
                <input name="folderModules"
                       type="text"
                       value="<?php printFormValue('folderModules') ?>">
                <span class="error"><?php printFormError('folderModules') ?></span>
                <span class="changed"><?php printFormChanges('folderModules') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   A placeholder                  |
            |                                  |
            -------------------------------- -->

            <label class="size33 disabled">
                <span class="caption">
                    for the Installer:
                </span>
                <input name="folderInstall"
                       type="text"
                       value="<?php printFormValue('folderInstall') ?>"
                       readonly>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 3                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    for the APP:
                </span>
                <input name="folderApp"
                       type="text"
                       value="<?php printFormValue('folderApp') ?>">
                <span class="error"><?php printFormError('folderApp') ?></span>
                <span class="changed"><?php printFormChanges('folderApp') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 4                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    APP variant:
                </span>
                <select name="folderAppVariant">
                    <?php printFormOptions('folderAppVariant') ?>
                </select>
                <span class="error"><?php printFormError('folderAppVariant') ?></span>
                <span class="changed"><?php printFormChanges('folderAppVariant') ?></span>
            </label>
        </fieldset>

        <!-- -----------------------------------
        |                                      |
        |   A note                             |
        |                                      |
        ------------------------------------ -->

        <p>
            Each directory name must end with a slash. All directories
            must be at the same nesting level. If a particular component
            is not needed, clear its directory field.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   A remark                           |
        |                                      |
        ------------------------------------ -->

        <blockquote class="iconized">
            <svg class="icon">
                <use xlink:href="#icon-info"></use>
            </svg>

            Required fields are marked with a red dot in the corner.
            In case of an input error, a red warning will appear under
            the wrong field. If a field is corrected by the Installer,
            a green notice will appear under that field.
        </blockquote>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>">
                &laquo; Back
            </a>
            <button type="submit" name="submitForm1" value="1">
                Next &raquo;
            </button>
        </nav>
    </form>
