<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the SeeAllOf buttons.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = a list of the related viewer names        ( see file tiny.news.feed/Themes/default/snippets/tools.tpl )
 *     $cms      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    if ( $params ) {                                    // if this viewers list is non-empty
        ?>
        <details class="btn all">
            <summary class="switch">
                <?php printValue(TINYFEED_INTERFACE_LIST) ?>
            </summary>
            <nav class="menu">
                <?php                                   // -----------------
                    foreach ( $params as $name ) {      //      walk through the provided list
                        $node = tinyGetBreadcrumb(      //          get a node name ( see file tiny.news.feed/Helper/Helper.php -> tinyGetBreadcrumb )
                                    $name               //          . . for this viewer name
                                );                      //
                        $root = [ 'url' => $name ];     //          make pseudo record for the root of that viewer list
                        ?>
                        <a href="<?php tinyPrintUrl($root) ?>">
                            <?php printValue($node) ?>
                        </a>
                        <?php                           //
                    }                                   //
                ?>
            </nav>
        </details>
        <?php                                           //
    }                                                   //
                                                        // -----------------
