<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the News Delete page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = the current news record ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE                   ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0                       ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = 'news'                  ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ?                       ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(0);                               // cache will expire immediately ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Take the steps that match the functionality of this page.
 *
 * -------------------------------------------------------------------------
 */


                                                        // -----------------
    global $item;                                       // refer to the incoming variable
                                                        // -----------------
    $error   = '';                                      // no error now
    $success = '';                                      // no success now
    $ok = getFormInput('submit');                       // get a form posting marker ( see file mimimi.modules/Helper/Helper.php -> getFormInput )
    if ( $ok ) {                                        // if that form is posted by human's click
                                                        // -----------------
        $error = TINYFEED_ERROR_CONFIRM_SURE;           //     let's say there is an error ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR_CONFIRM_SURE )
                                                        // -----------------
        $ok = getFormInput('sure');                     //     get the "I am sure" flag ( see file mimimi.modules/Helper/Helper.php -> getFormInput )
        if ( $ok ) {                                    //     if that flag is on
                                                        // -----------------
            $error   = '';                              //         no error now
            $success = TINYFEED_ERROR_DEMO;             //         let's say there is a success ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR_DEMO )
                                                        // -----------------
            if ( ! TINYFEED_ON_DEMO_NOW ) {             //         if we are not in demo mode ( see file tiny.news.feed/Constants.php -> TINYFEED_ON_DEMO_NOW )
                $cms                                    //             remove this news from database
                ->viewers                               //             . . via VIEWERS module ( see file tiny.news.feed/Viewers/Viewers.php )
                ->news                                  //             . . via NEWS submodule ( see file tiny.news.feed/Viewers/News/News.php -> mimimi.core/ModuleWithTable.php -> remove )
                ->remove(                               //             . . using this method
                    $item['id']                         //             . . . . for record with this identifier
                );                                      //
                                                        // -----------------
                $image = printItemField(                //             get the news image URL ( see file mimimi.modules/Helper/Helper.php -> printItemField )
                             'image',                   //             . . from this column
                             $item,                     //             . . from this publication
                             FALSE                      //             . . return as result, do not print
                         );                             //
                if ( $image ) {                         //             if this news contains image
                                                        // -----------------
                    $ok = $cms                          //                 check for a conflict with URL of another images
                          ->viewers                     //                 . . via VIEWERS module ( see file tiny.news.feed/Viewers/Viewers.php )
                          ->news                        //                 . . via NEWS submodule ( see file tiny.news.feed/Viewers/News/News.php -> testBy )
                          ->testBy(                     //                 . . using this method
                              'image',                  //                 . . . . by this column
                              $image,                   //                 . . . . with this value
                              $item['id']               //                 . . . . except for the news with this identifier
                          );                            //
                                                        // -----------------
                    if ( $ok ) {                        //                 if there are no URL doubles
                        removeMedia($image);            //                     remove that image ( see file mimimi.modules/Helper/Helper.php -> removeMedia )
                    }                                   //
                }                                       //
                                                        // -----------------
                mimimiStop(                             //             stop execution                    ( see file mimimi.core/Routines.php         -> mimimiStop )
                    printSiteUrl(FALSE) . 'news',       //             . . and go to the News List page  ( see file mimimi.modules/Helper/Helper.php -> printSiteUrl )
                    307                                 //             . . using 307 redirect
                );                                      //
            }                                           //
        }                                               //
    }                                                   //
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_NEWSDELETE_H1,       // make a pseudo publication ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSDELETE_H1 )
             'title'   => TINYFEED_NEWSDELETE_TITLE,    // . . with this title       ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSDELETE_TITLE )
             'meta'    => TINYFEED_NEWSDELETE_META,     // . . with this short text  ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSDELETE_META )
             'body'    => '',                           // . . no full text
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => '',                           // . . canonical URL is home
             'enabled' => FALSE ];                      // . . for "noindex, nofollow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="news delete" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_DELETE   // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_DELETE )
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * Administrative form.                 *
        *                                      *
        ------------------------------------ -->

        <form class="paginator form" method="post">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
            ?>

            <div class="error"  ><?php printValue($error)   ?></div>
            <div class="success"><?php printValue($success) ?></div>

            <fieldset class="switch">
                <label>
                    <input name="sure" value="1" type="checkbox">
                    <?php printValue(TINYFEED_INTERFACE_IAMSURE) ?>
                </label>
            </fieldset>

            <button class="btn tools submit" name="submit" value="1" type="submit">
                <?php printValue(TINYFEED_INTERFACE_SUBMIT) ?>
            </button>

            <a class="btn tools cancel" href="<?php printSiteUrl() ?>news">
                <?php printValue(TINYFEED_INTERFACE_CANCEL) ?>
            </a>
        </form>

        <!-- -----------------------------------
        *                                      *
        * The full text of news.               *
        *                                      *
        ------------------------------------ -->

        <div class="content page deleting <?php tinyPrintState($item) ?>">
            <?php                                       // -----------------
                $item['body'] = tinySanitize(           // avoid attacking the database by HTML injection ( see file tiny.news.feed/Helper/Helper.php -> tinySanitize )
                                    $item['body']       //
                                );                      //
                                                        // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $item                               // . . for this publication
                ]);                                     //
            ?>
        </div>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>