<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the newspaper content.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = incoming newspaper to read
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Display the list of newspaper sections.
     *
     * ---------------------------------------------------------------------
     */

    if ( $params[ 'articles' ] ) {

        /**
         * -----------------------------------------------------------------
         *
         * Create a rendering plan. It contains of two steps: display only
         * LAYOUT sections, display only SIDEBAR sections.
         *
         * -----------------------------------------------------------------
         */

        $plan = [
            'layout' => [
                'opentag'  => '',
                'closetag' => ''
            ],

            'sidebar' => [
                'opentag'  => '<div class="sidebar">' .
                                  '<div class="title">' .
                                      printValue( $params[ 'sidebar' ], FALSE ) .
                                  '</div>',
                'closetag' => '</div>'
            ]
        ];
        foreach ( $plan as $marker => $wrapper ) {
            $size = strlen( $marker );

            echo $wrapper[ 'opentag' ];

            /**
             * -------------------------------------------------------------
             *
             * Go through the sections of the newspaper.
             *
             * -------------------------------------------------------------
             */

            $num = 0;
            foreach ( $params[ 'articles' ] as $row ) {
                $num++;

                /**
                 * ---------------------------------------------------------
                 *
                 * If it's a section from the current render plan step.
                 *
                 * ---------------------------------------------------------
                 */

                $test = substr( $row[ 'layout' ], 0, $size );
                if ( $test == $marker ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Display the section.
                     *
                     * -----------------------------------------------------
                     */

                    ?>
                    <section class="article post-<?php printValue(       $num             );
                                                       printValue( ' ' . $row[ 'size'   ] );
                                                       printValue( ' ' . $row[ 'layout' ] );
                                                       printValue( ' ' . $row[ 'decor'  ] ); ?>">
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Title of the section, if present.
                             *
                             * ---------------------------------------------
                             */

                            if ( $row[ 'h1' ] ) {

                                // if no image other than ALT is provided, use it as a little title info
                                $alt = !  $row[ 'image'     ]
                                       && $row[ 'image_alt' ]
                                       ? ' <small>' .
                                               printValue( $row[ 'image_alt' ], FALSE ) .
                                          '</small>'
                                       : '';

                                // display title with link
                                if ( $row[ 'credits' ] ) {
                                    ?>
                                    <a class="credits" href="<?php printValue( $row[ 'credits' ] ) ?>" rel="nofollow noopener noreferrer">
                                        <h1 class="title">
                                            <?php
                                                printValue( $row[ 'h1' ] );
                                                echo $alt;
                                            ?>
                                        </h1>
                                    </a>
                                    <?php

                                // or display title without link
                                } else {
                                    ?>
                                    <h1 class="title">
                                        <?php
                                            printValue( $row[ 'h1' ] );
                                            echo $alt;
                                        ?>
                                    </h1>
                                    <?php
                                }
                            }

                            /**
                             * ---------------------------------------------
                             *
                             * Image of the section, if present.
                             *
                             * ---------------------------------------------
                             */

                            if ( $row[ 'image' ] ) {
                                ?>
                                <figure class="image">
                                    <?php
                                        if ( $row[ 'credits' ] ) {
                                            ?>
                                            <a class="credits" href="<?php printValue( $row[ 'credits' ] ) ?>" rel="nofollow noopener noreferrer">
                                                &nbsp;
                                            </a>
                                            <?php
                                        }
                                    ?>
                                    <img src="<?php printValue( $row[ 'image' ] ) ?>" loading="lazy" alt="<?php printValue( $row[ 'image_alt' ] ) ?>" />

                                    <figcaption class="alt">
                                        <?php printValue( $row[ 'image_alt' ] ) ?>
                                    </figcaption>
                                </figure>
                                <?php
                            }

                            /**
                             * ---------------------------------------------
                             *
                             * Text of the section, if present.
                             *
                             * ---------------------------------------------
                             */

                            $html = myGetText( $row );
                            if ( $html ) {
                                ?>
                                <div class="text"><?php echo $html ?></div>
                                <?php
                            }
                        ?>
                    </section>
                    <?php
                }
            }

            echo $wrapper[ 'closetag' ];
        }
    }
