<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the newspaper edit form.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = incoming newspaper to edit
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Process the submitted form.
     *
     * ---------------------------------------------------------------------
     */

    // get the newspaper ID
    $id = printItemField( 'id', $params, FALSE );

    $error   = '';
    $success = '';

    // check for form availability
    $ok = getFormInput( 'submit' );
    if ( $ok ) {

        // check for production (not demo) mode
        $ok = myGetSetting( 'on_production' );
        if ( $ok ) {

            // check for attack based on ID field
            $ok = $id == getFormInput( 'id' );
            if ( $ok ) {

                // get a page URL
                $url = makeSecureUrl(
                           getFormInput( 'url' )
                       );
                if ( $url == '' ) {
                    $url = myGenerateUrl();
                }

                // get the rest of the form fields
                $item = [
                    'url'       => $url,
                    'language'  => getFormInput( 'language'  ),
                    'enabled'   => getFormInput( 'visible'   ) == TRUE,
                    'edition'   => getFormInput( 'edition'   ),
                    'number'    => getFormInput( 'number'    ),
                    'date'      => getFormInput( 'date'      ) . ' ' . ( $id ? substr( $params[ 'date' ], 11 )
                                                                             : date  ( 'H:i:s'               ) ),
                    'slogan'    => getFormInput( 'slogan'    ),
                    'sidebar'   => getFormInput( 'sidebar'   ),
                    'meta'      => getFormInput( 'meta'      ),
                    'copyright' => getFormInput( 'copyright' ),
                    'credits'   => getFormInput( 'credits'   )
                ];

                // get the form fields of newspaper articles
                $item[ 'articles' ] = [ ];
                $list = mimimiPost( 'enabled', [ ] );
                $num = 0;
                foreach ( $list as $index => $row ) {
                    $row = [
                        'id'           => getFormInput( 'article_id', 0,     $index ),
                        'owner'        => getFormInput( 'owner',      0,     $index ),
                        'order'        => $num,
                        'size'         => getFormInput( 'size',       '',    $index ),
                        'layout'       => getFormInput( 'layout',     '',    $index ),
                        'decor'        => getFormInput( 'decor',      '',    $index ),
                        'h1'           => getFormInput( 'h1',         '',    $index ),
                        'text'         => mySanitizeText(
                                              getFormInput( 'text',   '',    $index )
                                          ),
                        'image_alt'    => getFormInput( 'image_alt',  '',    $index ),
                        'credits'      => getFormInput( 'backlink',   '',    $index ),

                        // remember that the image URL can link to an external file (see FALSE parameter)
                        'image'        => makeSecureUrl(
                                              getFormInput( 'image',  '',    $index ),
                                              FALSE
                                          ),

                        // remember that the editor can upload a new image
                        'image_local'  => getFormFile ( 'upload',     FALSE, $index ),
                        'image_server' => getFormFile ( 'upload',     TRUE,  $index )
                    ];

                    // if something has been entered
                    if ( $row[ 'h1'          ]
                    ||   $row[ 'text'        ]
                    ||   $row[ 'image'       ]
                    ||   $row[ 'image_local' ] ) {

                        // collect this article
                        $item[ 'articles' ][ ] = $row;
                        $num++;

                        // check for attack based on ID field
                        if ( ! $error ) {
                            if ( $row[ 'owner' ] != $id
                            ||   $row[ 'id'    ] && empty( $id ) ) {
                                $error = myGetSetting ( 'error_id_spoofing' );
                            }
                        }
                    }
                }

                // check for empty newspaper
                if ( ! $item[ 'articles' ] ) {
                    $error              = myGetSetting ( 'error_no_articles' );
                    $item[ 'articles' ] = [ myGenerateArticle( $id ) ];
                }

                // if something has been entered
                if ( ! $error ) {
                    if ( $item[ 'edition'   ]
                    &&   $item[ 'number'    ]
                    &&   $item[ 'date'      ]
                    &&   $item[ 'slogan'    ]
                    &&   $item[ 'copyright' ] ) {
                        $excludeIds    = [ ];
                        $excludeImages = [ ];

                        // check for a conflict with image URLs
                        $valid = [ 'webp',
                                   'jpg' ,
                                   'jpeg',
                                   'png' ,
                                   'gif' ,
                                   'bmp' ,
                                   'svg' ];
                        foreach ( $item[ 'articles' ] as $index => $row ) {
                            $image = $row[ 'image' ];
                            if ( $image == '' ) {
                                if ( $row[ 'image_local' ] ) {
                                    $image = basename( $row[ 'image_local' ] );
                                    if ( $image ) {
                                        $image = makeSecureUrl( 'media/newspapers/' . $url . '/' . $image );
                                    }
                                    $item[ 'articles' ][ $index ][ 'image' ] = $image;
                                }
                            }

                            // if the image of this article is valid, exclude it from removal
                            if ( $image ) {
                                $ok = validateMedia( $image, $valid );
                                if ( ! $ok ) {
                                    $error = myGetSetting ( 'error_bad_image' );
                                    break;
                                }
                                $excludeImages[ ] = $image;
                            }

                            // if this article has not been disabled, exclude it from deletion
                            $aid = $row[ 'id' ];
                            if ( $aid ) {
                                $excludeIds[ ] = $aid;
                            }
                        }

                        // check for a conflict with newspaper URL
                        if ( ! $error ) {
                            $ok = $cms->newspapers->testBy( 'url', $url, $id );
                            if ( $ok ) {

                                // delete old articles attached to this newspaper
                                myRemoveArticles( $params, $excludeIds, $excludeImages );

                                // save the newspaper
                                mySaveNewspaper( $params, $item );
                                mySaveArticles ( $params, $item );

                                // redirect to its page (307 = temporary, not cached)
                                $url = printSiteUrl(FALSE) . $url;
                                mimimiStop( $url, 307 );
                            } else {
                                $error = myGetSetting ( 'error_url_conflict' );
                            }
                        }
                    } else {
                        $error = myGetSetting ( 'error_empty_newspaper' );
                    }
                }

                // use the fields you entered now
                $params = $item;

            } else {
                $error = myGetSetting ( 'error_id_spoofing' );
            }
        } else {
            $success = myGetSetting( 'error_demo' );
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the form content.
     *
     * ---------------------------------------------------------------------
     */

?>

    <input name="id" type="hidden" value="<?php printValue( $id ) ?>">

    <div class="error"  ><?php printValue( $error   ) ?></div>
    <div class="success"><?php printValue( $success ) ?></div>

    <fieldset class="editbox language">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_language' ) ?>
                <small>
                    &lt;html lang=&quot;...&quot;&gt;
                </small>
            </small>
            <select name="language">
                <?php
                    $list = myGetSetting( 'languages', $params[ 'language' ] );
                    foreach ( $list as $value ) {
                        $attr = $value == $params[ 'language' ]
                                       ?  'selected'
                                       :  '';
                        ?>
                        <option <?php printValue( $attr ) ?>>
                            <?php printValue( $value ) ?>
                        </option>
                        <?php
                    }
                ?>
            </select>
            <span class="remark"><?php myPrintSetting( 'remark_language' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox url">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_url' ) ?>
                <small>
                    <?php printSiteUrl() ?>
                </small>
            </small>
            <input name="url"
                   type="text"
                   onblur="correctPageUrl(this)"
                   value="<?php printValue( $params[ 'url' ] ) ?>"
                   maxlength="255">
            <span class="remark"><?php myPrintSetting( 'remark_url' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox enabled">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_enabled' ) ?>
                <small>
                    approved=
                </small>
            </small>
            <select name="visible">
                <?php
                    $list = [ 0 => 'No',
                              1 => 'Yes' ];
                    foreach ( $list as $index => $value ) {
                        $attr = $index == $params[ 'enabled' ]
                                       ?  'selected'
                                       :  '';
                        ?>
                        <option value="<?php printValue( $index ) ?>" <?php printValue( $attr ) ?>>
                            <?php printValue( $value ) ?>
                        </option>
                        <?php
                    }
                ?>
            </select>
            <span class="remark"><?php myPrintSetting( 'remark_enabled' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_edition' ) ?>
                <small>
                    &lt;h1&gt;...&lt;/h1&gt;
                </small>
            </small>
            <input name="edition"
                   type="text"
                   value="<?php printValue( $params[ 'edition' ] ) ?>"
                   maxlength="25"
                   required>
            <span class="remark"><?php myPrintSetting( 'remark_edition' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox number">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_number' ) ?>
            </small>
            <input name="number"
                   type="text"
                   value="<?php printValue( $params[ 'number' ] ) ?>"
                   maxlength="25"
                   required>
            <span class="remark"><?php myPrintSetting( 'remark_number' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox date">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_date' ) ?>
            </small>
            <input name="date"
                   type="date"
                   value="<?php myPrintDate( $params[ 'date' ], TRUE ) ?>"
                   maxlength="10"
                   required>
            <span class="remark"><?php myPrintSetting( 'remark_date' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox slogan">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_slogan' ) ?>
            </small>
            <input name="slogan"
                   type="text"
                   value="<?php printValue( $params[ 'slogan' ] ) ?>"
                   maxlength="50"
                   required>
            <span class="remark"><?php myPrintSetting( 'remark_slogan' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox aside">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_sidebar' ) ?>
            </small>
            <input name="sidebar"
                   type="text"
                   value="<?php printValue( $params[ 'sidebar' ] ) ?>"
                   maxlength="50">
            <span class="remark"><?php myPrintSetting( 'remark_sidebar' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_meta' ) ?>
                <small>
                    &lt;meta content=&quot;...&quot; name=&quot;description&quot;&gt;
                </small>
            </small>
            <input name="meta"
                   type="text"
                   value="<?php printValue( $params[ 'meta' ] ) ?>"
                   maxlength="510">
            <span class="remark"><?php myPrintSetting( 'remark_meta' ) ?></span>
        </label>
    </fieldset>

    <?php
        if ( $params[ 'articles' ] ) {
            $plan = [
                'layout'  => '',
                'sidebar' => ''
            ];
            foreach ( $plan as $marker => $wrapper ) {
                $size = strlen( $marker );
                $num = 0;
                foreach ( $params[ 'articles' ] as $row ) {
                    $num++;
                    $test = substr( $row[ 'layout' ], 0, $size );
                    if ( $test == $marker ) {
                        ?>
                        <fieldset class="editcard">
                            <input class="switch" name="enabled[<?php printValue( $num ) ?>]" type="checkbox" checked value="1" tabindex="-1">
                            <input name="article_id[<?php printValue( $num ) ?>]" type="hidden" value="<?php printValue( $row[ 'id' ] ) ?>">
                            <input name="owner[<?php      printValue( $num ) ?>]" type="hidden" value="<?php printValue( $id          ) ?>">
                            <input name="order[<?php      printValue( $num ) ?>]" type="hidden" value="<?php printValue( $num         ) ?>">
                            <nav class="tools">
                                <a class="btn move-left"   href="<?php printSiteUrl() ?>" onclick="return moveLeft(this)"   title="<?php myPrintSetting( 'button_moveleft'   ) ?>">&laquo;</a>
                                <a class="btn make-new"    href="<?php printSiteUrl() ?>" onclick="return makeNew(this)"    title="<?php myPrintSetting( 'button_makenew'    ) ?>">+</a>
                                <a class="btn delete-this" href="<?php printSiteUrl() ?>" onclick="return deleteThis(this)" title="<?php myPrintSetting( 'button_deletethis' ) ?>">&cross;</a>
                                <a class="btn move-right"  href="<?php printSiteUrl() ?>" onclick="return moveRight(this)"  title="<?php myPrintSetting( 'button_moveright'  ) ?>">&raquo;</a>
                            </nav>
                            <label class="size">
                                <small class="title">
                                    <?php myPrintSetting( 'label_size' ) ?>
                                </small>
                                <select name="size[<?php printValue( $num ) ?>]">
                                    <?php
                                        $list = myGetSetting( 'post_sizes', $row[ 'size' ] );
                                        foreach ( $list as $value ) {
                                            $attr = $value == $row[ 'size' ]
                                                           ?  'selected'
                                                           :  '';
                                            ?>
                                            <option <?php printValue( $attr ) ?>>
                                                <?php printValue( $value ) ?>
                                            </option>
                                            <?php
                                        }
                                    ?>
                                </select>
                                <span class="remark"><?php myPrintSetting( 'remark_size' ) ?></span>
                            </label>
                            <label class="layout">
                                <small class="title">
                                    <?php myPrintSetting( 'label_layout' ) ?>
                                </small>
                                <select name="layout[<?php printValue( $num ) ?>]">
                                    <?php
                                        $list = myGetSetting( 'post_layouts', $row[ 'layout' ] );
                                        foreach ( $list as $value ) {
                                            $attr = $value == $row[ 'layout' ]
                                                           ?  'selected'
                                                           :  '';
                                            ?>
                                            <option <?php printValue( $attr ) ?>>
                                                <?php printValue( $value ) ?>
                                            </option>
                                            <?php
                                        }
                                    ?>
                                </select>
                                <span class="remark"><?php myPrintSetting( 'remark_layout' ) ?></span>
                            </label>
                            <label class="decor">
                                <small class="title">
                                    <?php myPrintSetting( 'label_decor' ) ?>
                                </small>
                                <select name="decor[<?php printValue( $num ) ?>]">
                                    <?php
                                        $list = myGetSetting( 'post_decors', $row[ 'decor' ] );
                                        foreach ( $list as $value ) {
                                            $attr = $value == $row[ 'decor' ]
                                                           ?  'selected'
                                                           :  '';
                                            ?>
                                            <option <?php printValue( $attr ) ?>>
                                                <?php printValue( $value ) ?>
                                            </option>
                                            <?php
                                        }
                                    ?>
                                </select>
                                <span class="remark"><?php myPrintSetting( 'remark_decor' ) ?></span>
                            </label>
                            <label>
                                <small class="title">
                                    <?php myPrintSetting( 'label_h1' ) ?>
                                </small>
                                <input name="h1[<?php printValue( $num ) ?>]"
                                       type="text"
                                       value="<?php printValue( $row[ 'h1' ] ) ?>"
                                       maxlength="150">
                                <span class="remark"><?php myPrintSetting( 'remark_h1' ) ?></span>
                            </label>
                            <label class="image">
                                <small class="title">
                                    <?php myPrintSetting( 'label_image' ) ?>
                                    <small>
                                        <?php printSiteUrl() ?>
                                    </small>
                                </small>
                                <input name="image[<?php printValue( $num ) ?>]"
                                       type="text"
                                       onblur="correctImageUrl(this)"
                                       value="<?php printValue( $row[ 'image' ] ) ?>"
                                       maxlength="255">
                                <span class="remark"><?php myPrintSetting( 'remark_image' ) ?></span>
                            </label>
                            <label class="file">
                                <small class="title">
                                    <?php myPrintSetting( 'label_img_file' ) ?>
                                    <small>
                                        from your device
                                    </small>
                                </small>
                                <!-- maximal file size is 5Mb, that is 5 * 1024 * 1024 = 5242880 bytes -->
                                <input type="hidden" name="MAX_FILE_SIZE" value="5242880">
                                <input name="upload[<?php printValue( $num ) ?>]"
                                       type="file">
                                <span class="remark"><?php myPrintSetting( 'remark_img_file' ) ?></span>
                            </label>
                            <label>
                                <small class="title">
                                    <?php myPrintSetting( 'label_image_alt' ) ?>
                                </small>
                                <input name="image_alt[<?php printValue( $num ) ?>]"
                                       type="text"
                                       value="<?php printValue( $row[ 'image_alt' ] ) ?>"
                                       maxlength="255">
                                <span class="remark"><?php myPrintSetting( 'remark_image_alt' ) ?></span>
                            </label>
                            <label>
                                <small class="title">
                                    <?php myPrintSetting( 'label_text' ) ?>
                                </small>
                                <textarea name="text[<?php printValue( $num ) ?>]" maxlength="8190"><?php
                                                                                                        printValue(
                                                                                                            preg_replace(
                                                                                                                '~[\r\n]+~u' ,
                                                                                                                "\r\n\r\n"   ,
                                                                                                                $row[ 'text' ]
                                                                                                            )
                                                                                                        )
                                                                                                    ?></textarea>
                                <span class="remark"><?php myPrintSetting( 'remark_text' ) ?></span>
                            </label>
                            <label>
                                <small class="title">
                                    <?php myPrintSetting( 'label_backlink' ) ?>
                                </small>
                                <input name="backlink[<?php printValue( $num ) ?>]"
                                       type="text"
                                       value="<?php printValue( $row[ 'credits' ] ) ?>"
                                       maxlength="255">
                                <span class="remark"><?php myPrintSetting( 'remark_backlink' ) ?></span>
                            </label>
                        </fieldset>
                        <?php
                    }
                }
            }
        }
    ?>

    <br>

    <fieldset class="editbox copyright">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_copyright' ) ?>
            </small>
            <input name="copyright"
                   type="text"
                   value="<?php printValue( $params[ 'copyright' ] ) ?>"
                   maxlength="150"
                   required>
            <span class="remark"><?php myPrintSetting( 'remark_copyright' ) ?></span>
        </label>
    </fieldset>

    <fieldset class="editbox backlink">
        <label>
            <small class="title">
                <?php myPrintSetting( 'label_credits_url' ) ?>
            </small>
            <input name="credits"
                   type="text"
                   value="<?php printValue( $params[ 'credits' ] ) ?>"
                   maxlength="255">
            <span class="remark"><?php myPrintSetting( 'remark_credits_url' ) ?></span>
        </label>
    </fieldset>

    <br>

    <button class="btn submit" name="submit" value="1" type="submit">
        <?php myPrintSetting( 'edit_submit' ) ?>
    </button>

    <a class="btn cancel" href="<?php printSiteUrl() ?>">
        <?php myPrintSetting( 'edit_cancel' ) ?>
    </a>
