<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Edit Settings" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = incoming list of website settings to edit
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus200();
    sendHeaderExpires( 0 );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Process the submitted form.
     *
     * ---------------------------------------------------------------------
     */

    $error   = '';
    $success = '';

    // check for form availability
    $ok = getFormInput( 'submit' );
    if ( $ok ) {

        // check for production (not demo) mode
        $ok = myGetSetting( 'on_production' );
        if ( $ok ) {

            // go through the submitted settings
            $items = mimimiPost( 'setting' );
            if ( is_array( $items ) ) {
                foreach ( $items as $id => $value ) {

                    // find it in the incoming list
                    if ( $params ) {
                        foreach ( $params as $index => $row ) {
                            if ( $row[ 'id' ] == $id ) {
                                $value = preg_replace( '~(^\s+|\s+$)~u', '', $value );

                                // update this setting if it has been changed
                                if ( $row[ 'value' ] != $value ) {
                                    $cms->settings->update( $id, [ 'value' => $value ] );

                                    // update it in the incoming list
                                    $params[ $index ][ 'value' ] = $value;
                                }
                                break;
                            }
                        }
                    }
                }
            }

        } else {
            $success = myGetSetting( 'error_demo' );
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="settings edit" lang="<?php myPrintSetting( 'settings_language' ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php myPrintSetting( 'settings_title' ) ?>
        </title>
        <meta name="robots"      content="noindex, nofollow">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <div class="wrapper">
                <div class="edition">
                    <?php myPrintSetting( 'settings_edition' ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php myPrintSetting( 'settings_number' ) ?>
                        </div>
                        <div class="slogan">
                            <?php myPrintSetting( 'settings_slogan' ) ?>
                        </div>
                    </div>
                </aside>

                <form class="form settings" method="post">
                    <div class="error"  ><?php printValue( $error   ) ?></div>
                    <div class="success"><?php printValue( $success ) ?></div>

                    <table class="list settings">
                        <tbody class="wrapper">
                            <?php
                                /**
                                 * -----------------------------------------
                                 *
                                 * Display the incoming list as input boxes.
                                 *
                                 * -----------------------------------------
                                 */

                                if ( $params ) {
                                    foreach ( $params as $row ) {
                                        $remark = '';
                                        switch ( $row[ 'alias' ] ) {
                                            case 'ips_admin':
                                            case 'ips_editor':
                                                $remark = 'your IP is ' . mimimiServer( 'REMOTE_ADDR' ) . ' now';
                                                break;
                                        }
                                        ?>
                                        <tr class="row setting">
                                            <td class="cell alias">
                                                <?php printValue( $row[ 'alias' ] ) ?>
                                            </td>

                                            <td class="cell value"
                                                data-remark="<?php printValue( $remark ) ?>">

                                                <input name="setting[<?php printValue( $row[ 'id'    ] ) ?>]"
                                                       type="text"
                                                       value="<?php        printValue( $row[ 'value' ] ) ?>"
                                                       maxlength="510">
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                            ?>
                        </tbody>
                    </table>

                    <button class="btn submit" name="submit" value="1" type="submit">
                        <?php myPrintSetting( 'settings_submit' ) ?>
                    </button>

                    <a class="btn cancel" href="<?php printSiteUrl() ?>">
                        <?php myPrintSetting( 'settings_cancel' ) ?>
                    </a>
                </form>

                <aside class="footer">
                    <div class="wrapper">
                        <div class="copyright">
                            <?php myPrintSetting( 'home_copyright' ) ?>
                        </div>
                        <a class="credits" href="https://mimimi.software/" rel="nofollow noopener noreferrer" tabindex="-1">
                            Powered by MiMiMi
                        </a>
                    </div>
                </aside>
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                mimimiModule(
                    'snippets/signpost.tpl'
                );
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>