<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the SITEMAP.XML document.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = incoming list of newspapers to read
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderXML();
    sendStatus200();
    sendHeaderExpires();
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the document content.
     *
     * ---------------------------------------------------------------------
     */

?><?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <url>
        <loc>
            <?php printSiteUrl() ?>
        </loc>
    </url>

    <?php
        /**
         * -----------------------------------------------------------------
         *
         * Display the incoming list as URLs.
         *
         * -----------------------------------------------------------------
         */

        if ( $params ) {
            foreach ( $params as $row ) {
                ?>
                <url>
                    <loc>
                        <?php
                            printSiteUrl();
                            printValue( $row[ 'url' ] );
                        ?>
                    </loc>
                </url>
                <?php
            }
        }
    ?>
</urlset>
