<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Read Newspaper" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = incoming newspaper to read
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus200();
    sendHeaderExpires(
        $cms->isAdmin() ? 0    // no caching if you are an admin
                        : 1    // otherwise cache for 1 hour
    );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="newspaper read" lang="<?php printValue( $params[ 'language' ] ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php printValue( $params[ 'edition' ] ) ?>
        </title>
        <meta name="description" content="<?php printValue( $params[ 'meta' ] ) ?>">
        <meta name="robots"      content="index, follow">
        <link rel="canonical"    href="<?php printPageUrl() ?>">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <div class="wrapper">
                <div class="edition">
                    <?php printValue( $params[ 'edition' ] ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php printValue( $params[ 'number' ] ) ?>
                        </div>
                        <div class="date">
                            <?php myPrintDate( $params[ 'date' ] ) ?>
                        </div>
                        <div class="slogan">
                            <?php printValue( $params[ 'slogan' ] ) ?>
                        </div>
                    </div>
                </aside>

                <main class="content" data-moderating="<?php myPrintModerating( $params ) ?>">
                    <?php
                        mimimiModule([
                            'snippets/show-newspaper.tpl',
                            $params
                        ]);
                    ?>
                </main>

                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Generate administrative tools.
                     *
                     * -----------------------------------------------------
                     */

                    mimimiModule([
                        'snippets/tools.tpl',
                        $params
                    ]);
                ?>

                <aside class="footer">
                    <div class="wrapper">
                        <a class="copyright" href="<?php printValue( $params[ 'credits' ] ) ?>" rel="nofollow noopener noreferrer" tabindex="-1">
                            <?php printValue( $params[ 'copyright' ] ) ?>
                        </a>
                        <a class="credits" href="https://mimimi.software/" rel="nofollow noopener noreferrer" tabindex="-1">
                            Powered by MiMiMi
                        </a>
                    </div>
                </aside>
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                mimimiModule([
                    'snippets/signpost.tpl',
                    $params
                ]);
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>