<?php /* =======================================================
|                                                              |
|   Template to display the page's form named FORM-5           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Make the DISABLED/EDITABLE attribute   |
    |   and the DISABLED/REQUIRED class for    |
    |   INPUTS (see them in the HTML layout    |
    |   below, and see the related INPUT 2     |
    |   on the STEP-1 page, and see the        |
    |   related INPUT named "modulesTelegram"  |
    |   on the STEP-3 page, and see the)       |
    |   related INPUT named "modulesSms" on    |
    |   the STEP-3 page)                       |
    |                                          |
    ----------------------------------------- */

    $param  = getFlashbackPrefix() . 'folderModules';
    $param2 = getFlashbackPrefix() . 'modulesTelegram';
    $param3 = getFlashbackPrefix() . 'modulesSms';
    $inputAttribute  = getSession($param)
                       ? ''
                       : 'disabled';
    $inputAttribute2 = !$inputAttribute &&
                       getSession($param2)
                       ? ''
                       : 'disabled';
    $inputAttribute3 = !$inputAttribute &&
                       getSession($param3)
                       ? ''
                       : 'disabled';
    $inputClass2     = $inputAttribute2
                       ? 'disabled'
                       : '';
    $inputClass3     = $inputAttribute3
                       ? 'disabled'
                       : '';

    /* -----------------------------------------
    |                                          |
    |   Define the controlled form fields:     |
    |       name         = a field name        |
    |       value        = its initial value   |
    |       options      = list of values for  |
    |                      tag <select> in     |
    |                      format "Value" or   |
    |                      "Value|To Display"  |
    |       flashback    = TRUE if save the    |
    |                      posted field in     |
    |                      session and restore |
    |                      it on next time     |
    |       corrected    = a list of regular   |
    |                      expressions to      |
    |                      optimize the posted |
    |                      field before        |
    |                      checking for errors |
    |       required     = TRUE if the posted  |
    |                      field cannot be     |
    |                      empty               |
    |       requ..Error  = a message if this   |
    |                      field is empty      |
    |       format       = a regular expression|
    |                      to validate the     |
    |                      posted field        |
    |       formatError  = a message if this   |
    |                      field is incorrect  |
    |       cha..Message = a message if this   |
    |                      field is changed    |
    |       readonly     = TRUE if ignore this |
    |                      field and always use|
    |                      its initial value   |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: Define this variable as global   |
    |         to use below (see routines       |
    |         printFormValue, printFormError,  |
    |         and printFormChanges in the      |
    |         HELPER.PHP file).                |
    |                                          |
    ----------------------------------------- */

    global $form;
    $form = array(
        array(
            'name'           => 'notifyEmailsWeb',
            'value'          => MIMIMI_EMAILS_FOR_WEBMASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyEmailsContent',
            'value'          => MIMIMI_EMAILS_FOR_CONTENT_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyEmailsTraffic',
            'value'          => MIMIMI_EMAILS_FOR_TRAFFIC_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyEmailsSecurity',
            'value'          => MIMIMI_EMAILS_FOR_SECURITY_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),

        /* ---------------------------------- */

        array(
            'name'           => 'notifyTelegramsWeb',
            'value'          => MIMIMI_TELEGRAMS_FOR_WEBMASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyTelegramsContent',
            'value'          => MIMIMI_TELEGRAMS_FOR_CONTENT_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyTelegramsTraffic',
            'value'          => MIMIMI_TELEGRAMS_FOR_TRAFFIC_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyTelegramsSecurity',
            'value'          => MIMIMI_TELEGRAMS_FOR_SECURITY_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.,a-z0-9\s@_-]+/ui' => '-',
                                    '/\s+/u'                => ' ',
                                    '/\s*,+\s*/u'           => ', ',
                                    '/(,\s)+/u'             => ', ',
                                    '/^[,\s]+/u'            => '',
                                    '/[,\s]+$/u'            => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),

        /* ---------------------------------- */

        array(
            'name'           => 'notifyPhonesWeb',
            'value'          => MIMIMI_PHONES_FOR_WEBMASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^,0-9\s]+/u' => ' ',
                                    '/\s+/u'        => ' ',
                                    '/\s*,+\s*/u'   => ', ',
                                    '/(,\s)+/u'     => ', ',
                                    '/^[,\s]+/u'    => '',
                                    '/[,\s]+$/u'    => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyPhonesContent',
            'value'          => MIMIMI_PHONES_FOR_CONTENT_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^,0-9\s]+/u' => ' ',
                                    '/\s+/u'        => ' ',
                                    '/\s*,+\s*/u'   => ', ',
                                    '/(,\s)+/u'     => ', ',
                                    '/^[,\s]+/u'    => '',
                                    '/[,\s]+$/u'    => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyPhonesTraffic',
            'value'          => MIMIMI_PHONES_FOR_TRAFFIC_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^,0-9\s]+/u' => ' ',
                                    '/\s+/u'        => ' ',
                                    '/\s*,+\s*/u'   => ', ',
                                    '/(,\s)+/u'     => ', ',
                                    '/^[,\s]+/u'    => '',
                                    '/[,\s]+$/u'    => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'notifyPhonesSecurity',
            'value'          => MIMIMI_PHONES_FOR_SECURITY_MASTER,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^,0-9\s]+/u' => ' ',
                                    '/\s+/u'        => ' ',
                                    '/\s*,+\s*/u'   => ', ',
                                    '/(,\s)+/u'     => ', ',
                                    '/^[,\s]+/u'    => '',
                                    '/[,\s]+$/u'    => ''
                                ),
            'changedMessage' => 'Corrected by Installer. Is it right?'
        )
    );

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > restore (flashback) value of     |
    |         the form fields from the session |
    |       > validate posted form             |
    |       > if that form is OK               |
    |           > remember "STEP-5 is passed"  |
    |           > send soft redirect to FINAL  |
    |           > return (break this template) |
    |       > end if                           |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    flashbackForm($form);
    $ok = validateForm($form, 'submitForm5');
    if ($ok) {
        setCheckpoint('step5'); ?>

        <script>
            location.replace('<?php printSiteUri() ?>final')
        </script> <?php

        return;
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?>  <form action="<?php printPageUri() ?>" method="post">
        <fieldset>
            <legend>
                For email notification
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 1                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    to webmaster:
                </span>
                <input name="notifyEmailsWeb"
                       type="text"
                       value="<?php printFormValue('notifyEmailsWeb') ?>">
                <span class="error"><?php printFormError('notifyEmailsWeb') ?></span>
                <span class="changed"><?php printFormChanges('notifyEmailsWeb') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 2                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    to copywriter:
                </span>
                <input name="notifyEmailsContent"
                       type="text"
                       value="<?php printFormValue('notifyEmailsContent') ?>">
                <span class="error"><?php printFormError('notifyEmailsContent') ?></span>
                <span class="changed"><?php printFormChanges('notifyEmailsContent') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 3                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    to SEO master:
                </span>
                <input name="notifyEmailsTraffic"
                       type="text"
                       value="<?php printFormValue('notifyEmailsTraffic') ?>">
                <span class="error"><?php printFormError('notifyEmailsTraffic') ?></span>
                <span class="changed"><?php printFormChanges('notifyEmailsTraffic') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 4                     |
            |                                  |
            -------------------------------- -->

            <label>
                <span class="caption">
                    to security:
                </span>
                <input name="notifyEmailsSecurity"
                       type="text"
                       value="<?php printFormValue('notifyEmailsSecurity') ?>">
                <span class="error"><?php printFormError('notifyEmailsSecurity') ?></span>
                <span class="changed"><?php printFormChanges('notifyEmailsSecurity') ?></span>
            </label>
        </fieldset>

        <p>
            Any of these fields are a comma-separated list
            of emails.
        </p>

        <fieldset>
            <legend>
                For Telegram notification
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 5                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    to webmaster:
                </span>
                <input name="notifyTelegramsWeb"
                       type="text"
                       value="<?php printFormValue('notifyTelegramsWeb') ?>">
                <span class="error"><?php printFormError('notifyTelegramsWeb') ?></span>
                <span class="changed"><?php printFormChanges('notifyTelegramsWeb') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 6                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    to copywriter:
                </span>
                <input name="notifyTelegramsContent"
                       type="text"
                       value="<?php printFormValue('notifyTelegramsContent') ?>">
                <span class="error"><?php printFormError('notifyTelegramsContent') ?></span>
                <span class="changed"><?php printFormChanges('notifyTelegramsContent') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 7                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    to SEO master:
                </span>
                <input name="notifyTelegramsTraffic"
                       type="text"
                       value="<?php printFormValue('notifyTelegramsTraffic') ?>">
                <span class="error"><?php printFormError('notifyTelegramsTraffic') ?></span>
                <span class="changed"><?php printFormChanges('notifyTelegramsTraffic') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 8                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass2) ?>">
                <span class="caption">
                    to security:
                </span>
                <input name="notifyTelegramsSecurity"
                       type="text"
                       value="<?php printFormValue('notifyTelegramsSecurity') ?>">
                <span class="error"><?php printFormError('notifyTelegramsSecurity') ?></span>
                <span class="changed"><?php printFormChanges('notifyTelegramsSecurity') ?></span>
            </label>
        </fieldset>

        <p>
            Any of these fields are a comma-separated list
            of Telegram's public groups or channels with
            leading <em>@</em> character.
        </p>

        <fieldset>
            <legend>
                For SMS notification
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 9                     |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass3) ?>">
                <span class="caption">
                    to webmaster:
                </span>
                <input name="notifyPhonesWeb"
                       type="text"
                       value="<?php printFormValue('notifyPhonesWeb') ?>">
                <span class="error"><?php printFormError('notifyPhonesWeb') ?></span>
                <span class="changed"><?php printFormChanges('notifyPhonesWeb') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 10                    |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass3) ?>">
                <span class="caption">
                    to copywriter:
                </span>
                <input name="notifyPhonesContent"
                       type="text"
                       value="<?php printFormValue('notifyPhonesContent') ?>">
                <span class="error"><?php printFormError('notifyPhonesContent') ?></span>
                <span class="changed"><?php printFormChanges('notifyPhonesContent') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 11                    |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass3) ?>">
                <span class="caption">
                    to SEO master:
                </span>
                <input name="notifyPhonesTraffic"
                       type="text"
                       value="<?php printFormValue('notifyPhonesTraffic') ?>">
                <span class="error"><?php printFormError('notifyPhonesTraffic') ?></span>
                <span class="changed"><?php printFormChanges('notifyPhonesTraffic') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 12                    |
            |                                  |
            -------------------------------- -->

            <label class="<?php printValue($inputClass3) ?>">
                <span class="caption">
                    to security:
                </span>
                <input name="notifyPhonesSecurity"
                       type="text"
                       value="<?php printFormValue('notifyPhonesSecurity') ?>">
                <span class="error"><?php printFormError('notifyPhonesSecurity') ?></span>
                <span class="changed"><?php printFormChanges('notifyPhonesSecurity') ?></span>
            </label>
        </fieldset>

        <p>
            Any of these fields are a comma-separated list
            of phones provided in international format.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   A remark                           |
        |                                      |
        ------------------------------------ -->

        <blockquote class="iconized">
            <svg class="icon">
                <use xlink:href="#icon-info"></use>
            </svg>

            Required fields are marked with a red dot in the corner.
            In case of an input error, a red warning will appear under
            the wrong field. If a field is corrected by the Installer,
            a green notice will appear under that field.
        </blockquote>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>step-4">
                &laquo; Back
            </a>
            <button type="submit" name="submitForm5" value="1">
                Next &raquo;
            </button>
        </nav>
    </form>
