<?php
/**
 * -------------------------------------------------------------------------
 * Basis for system modules.
 *
 * In the simplest case, the application being developed consists of two
 * layers. Such an application represents the imaginary first layer of
 * development. This app is an umbrella node for all callable modules,
 * which are the imaginary second layer.
 *
 * For example:
 *
 *     $someApp ─┬──> someModule1 ──> someMethod()
 *               ├──> someModule2 ──> someMethod()
 *               ├──> someModule3 ──> someMethod()
 *               └──> someModule4 ──> someMethod()
 *
 * These modules are derived from the MimimiModule class. And they are
 * each in their own subfolder, in the same place where the application
 * source file is located.
 *
 * -------------------------------------------------------------------------
 *
 * Implemented properties below are:
 *     $umbrella
 *     $cms
 *
 * Implemented methods below are:
 *     __construct
 *     run
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Core
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    CC BY 4
 *             https://www.creativecommons.org/licenses/by/4.0
 * -------------------------------------------------------------------------
 */

class MimimiModule {

    /**
     * ---------------------------------------------------------------------
     * Reference to the parent umbrella node (closest module).
     *
     * @var object|false
     * @access public
     * ---------------------------------------------------------------------
     */

    public $umbrella = false;

    /**
     * ---------------------------------------------------------------------
     * Reference to the application node (root module).
     *
     * @var object|false
     * @access public
     * ---------------------------------------------------------------------
     */

    public $cms = false;

    /**
     * ---------------------------------------------------------------------
     * Public constructor for creating an instance of this class.
     *
     * @public
     * @param   object|false  $owner  Reference to the parent module.
     * ---------------------------------------------------------------------
     */

    public function __construct ( & $owner = false ) {
        $this->umbrella = false;
        $this->cms = false;
        if (is_object($owner)) {
            $this->umbrella = $owner;
            $this->cms = isset($owner->cms) &&
                         is_object($owner->cms)
                         ? $owner->cms
                         : $owner;
        }
    }

    /**
     * ---------------------------------------------------------------------
     * Public method to run this module.
     *
     * @public
     * @param   mixed  $params  Some parameters if you need.
     * @return  mixed           Some results if you need.
     * ---------------------------------------------------------------------
     */

    public function run ( $params = '' ) {
        return true;
    }
};