<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the publication body.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = the current publication                   ( see file    tiny.news.feed/Themes/default/*-page.tpl
 *                                                             or see file tiny.news.feed/Themes/default/snippets/card-*.tpl )
 *     $cms      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * The image.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $ok = ! empty($params['image'])                     // check if this publication contains image
         && is_string($params['image']);                //
    if ( $ok ) {                                        // if it's true
        echo '<figure class="image">';                  //     send a related HTML markup
        echo     '<img src="' . printValue(             //     . . with this column ( see file mimimi.modules/Helper/Helper.php -> printValue )
                                    $params['image'],   //
                                    FALSE               //
                                ) . '" alt="" ' .       //
                                    'loading="lazy">';  //
        echo '</figure>';                               //
    }                                                   //
                                                        // -----------------

    /**
     * ---------------------------------------------------------------------
     *
     * The name.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $ok = ! empty($params['h1'])                        // check if this publication contains name
         && is_string($params['h1']);                   //
    if ( $ok ) {                                        // if it's true
        echo '<h1 class="title">';                      //     send a related HTML markup
                 printValue($params['h1']);             //     . . with this column ( see file mimimi.modules/Helper/Helper.php -> printValue )
        echo '</h1>';                                   //
    } else {                                            // otherwise
        $ok = ! empty($params['title'])                 //     check if this publication contains title
             && is_string($params['title']);            //
        if ( $ok ) {                                    //     if it's true
            echo '<h1 class="title">';                  //         send a related HTML markup
                     printValue($params['title']);      //         . . with this column ( see file mimimi.modules/Helper/Helper.php -> printValue )
            echo '</h1>';                               //
        }                                               //
    }                                                   //
                                                        // -----------------

    /**
     * ---------------------------------------------------------------------
     *
     * The short text.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $ok = ! empty($params['meta'])                      // check if this publication contains short text
         && is_string($params['meta']);                 //
    if ( $ok ) {                                        // if it's true
        echo '<p class="info">';                        //     send a related HTML markup
                 printValue($params['meta']);           //     . . with this column ( see file mimimi.modules/Helper/Helper.php -> printValue )
        echo '</p>';                                    //
    }                                                   //
                                                        // -----------------

    /**
     * ---------------------------------------------------------------------
     *
     * The full text.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $ok = ! empty($params['body'])                      // check if this publication contains full text
         && is_string($params['body']);                 //
    if ( $ok ) {                                        // if it's true
        echo '<section class="text">';                  //     send a related HTML markup
        echo     $params['body'];                       //     . . with this column
        echo '</section>';                              //
    }                                                   //
                                                        // -----------------
