<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the Search List page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE                                          ( see file tiny.news.feed/Router/Router.php         -> run -> $item )
 *     $items  = array of items listed on the current list page ( see file tiny.news.feed/Viewers/Search/Search.php -> run -> $items )
 *     $page   = number of the current list page                ( see file tiny.news.feed/Viewers/Search/Search.php -> run -> $page )
 *     $viewer = 'search'                                       ( see file tiny.news.feed/Router/Router.php         -> run -> $viewer )
 *     $url    = ''                                             ( see file tiny.news.feed/Viewers/Search/Search.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(0);                               // cache will expire immediately ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    global $page,                                       // refer to the incoming variables
           $items;                                      //
                                                        // -----------------
    $query = $cms                                       // get the query string
             ->viewers                                  // . . via VIEWERS module ( see file tiny.news.feed/Viewers/Viewers.php -> getQueryParam )
             ->getQueryParam(                           // . . using this method
                 'q'                                    //     . . from this POST or GET parameter ( see the INPUT tag named "q" in file tiny.news.feed/Themes/default/snippets/form-search.tpl )
             );                                         //
                                                        // -----------------
    $ok = ! empty($items);                              // are there any results?
                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_SEARCHLIST_H1 . '"' . $query . '"', // make a pseudo publication         ( see file tiny.news.feed/Constants.php -> TINYFEED_SEARCHLIST_H1 )
             'title'   => TINYFEED_SEARCHLIST_TITLE . $page,           // . . with this title + page number ( see file tiny.news.feed/Constants.php -> TINYFEED_SEARCHLIST_TITLE )
             'meta'    => $ok                                          // . . with this short text          ( see file tiny.news.feed/Constants.php -> TINYFEED_SEARCHLIST_META )
                              ? TRUE                                   //     . . when results are found
                              : TINYFEED_SEARCHLIST_META,              //     . . when no results
             'body'    => TRUE,                         // . . no full text
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => 'search',                     // . . canonical URL is the root of news list
             'enabled' => $ok ];                        // . . for "index, follow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="search list" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet                   ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template             ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_LIST     // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_LIST )
                                  . ' ' . $page         //
            ]);                                         //
                                                        // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/form-search.tpl'              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-search.tpl )
            );                                          //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The list of news cards.              *
        *                                      *
        ------------------------------------ -->

        <main class="content list">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
                                                        // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/results.tpl',             // . . from this template ( see file tiny.news.feed/Themes/default/snippets/results.tpl )
                    $items                              // . . with this list
                ]);                                     //
            ?>
        </main>

        <!-- -----------------------------------
        *                                      *
        * Pagination and administrative tools. *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            global $viewer;                             // refer to the incoming variable
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/pagination.tpl',              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/pagination.tpl )
                $viewer                                 // . . for this viewer name
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>