<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the News page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = the current news record ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE                   ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0                       ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = 'news'                  ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ?                       ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    global $item;                                       // refer to the incoming variable
    $okEdit = $cms->amIAdmin();                         // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
                                                        // -----------------
    $item['body'] = tinySanitize( $item['body'] );      // avoid attacking the database by HTML injection ( see file tiny.news.feed/Helper/Helper.php -> tinySanitize )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(                                  // cache will expire             ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
        $okEdit ? 0                                     // . . immediately if user is an admin
                : 1                                     // . . otherwise after 1 hour
    );                                                  //
    sendHeaderLastModified(                             // last modified time equals     ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
        0, $item                                        // . . creation time of this news
    );                                                  //
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

?>
<!DOCTYPE html>
<html class="news" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $item                                       // . . for this publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_PAGE     // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_PAGE )
            ]);                                         //
                                                        // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/form-search.tpl'              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-search.tpl )
            );                                          //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The full text of news.               *
        *                                      *
        ------------------------------------ -->

        <main class="content page <?php tinyPrintState($item) ?>">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $item                               // . . for this publication
                ]);                                     //
            ?>
        </main>

        <!-- -----------------------------------
        *                                      *
        * Administrative tools.                *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/tools.tpl',                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/tools.tpl )
                $item                                   // . . as specific tools for this publication
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>