<?php
/**
 * -------------------------------------------------------------------------
 * The SETTINGS module to work with the SETTINGS database table.
 *
 * This module is loaded automatically. It fires the moment a web developer
 * first touches this module in the source code of the website's backend or
 * frontend.
 *
 * -------------------------------------------------------------------------
 *
 * Overridden properties below are:
 *     PROTECTED  $table  ───────────> PUBLIC
 *     PROTECTED  $tableFields
 *                      ├──> id        INTEGER (auto incremented)
 *                      ├──> name      STRING  (length 60)
 *                      ├──> value     STRING  (length 2400)
 *                      ├──> created   DATE
 *                      └──> modified  DATE
 *     PROTECTED  $tableKeys
 *                      ├──> id        UNIQUE
 *                      ├──> name      UNIQUE
 *                      ├──> created
 *                      └──> modified
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Modules
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    CC BY 4
 *             https://www.creativecommons.org/licenses/by/4.0
 * -------------------------------------------------------------------------
 */

mimimiInclude('ModuleWithTable.php');
class MimimiSettings extends MimimiModuleWithTable {

    /**
     * ---------------------------------------------------------------------
     * Database table name.
     *
     * @var string
     * @access public
     * ---------------------------------------------------------------------
     */

    public $table = 'settings';

    /**
     * ---------------------------------------------------------------------
     * Database table columns.
     *
     * @var array
     * @access protected
     * ---------------------------------------------------------------------
     */

    protected $tableFields = [
                  '`id`        BIGINT(20)     NOT NULL  AUTO_INCREMENT                             COMMENT "setting system identifier"',
                  '`name`      VARCHAR(60)    NOT NULL  DEFAULT ""                                 COMMENT "setting name"',
                  '`value`     VARCHAR(2400)  NOT NULL  DEFAULT ""                                 COMMENT "setting value"',
                  '`created`   DATETIME       NOT NULL  DEFAULT CURRENT_TIMESTAMP                  COMMENT "creation date"',
                  '`modified`  DATETIME       NULL      DEFAULT NULL  ON UPDATE CURRENT_TIMESTAMP  COMMENT "modification date"'
              ];

    /**
     * ---------------------------------------------------------------------
     * Database table keys.
     *
     * @var array
     * @access protected
     * ---------------------------------------------------------------------
     */

    protected $tableKeys = [
                  'PRIMARY KEY (`id`)',
                  'UNIQUE  KEY (`name`)',
                  'KEY         (`created`)',
                  'KEY         (`modified`)'
              ];
};