<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Core's home page            |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = Core's folder name (ended with slash)      |
|       $filename = this template filepath (relative to the    |
|                   Core's folder)                             |
|       $file     = this template's absolute filepath          |
|       $cms      = Core's application object                  |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |       > switch "what is requested?"      |
    |           > when "Disable analysis"      |
    |               > save state in session    |
    |               > inform your masters      |
    |               > send response "OK"       |
    |           > otherwise                    |
    |               > send status "200 OK"     |
    |               > if analysis is enabled   |
    |                   > inform your masters  |
    |               > end if                   |
    |       > end switch                       |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php', TRUE);
    startSession();
    switch (mimimiRequest('action')) {
        case 'disable':
            setSession('noAnalysis', TRUE);
            informAnalysis();
            mimimiStop('OK', 200);
        default:
            sendStatus200();
            if (!getSession('noAnalysis')) {
                informVisit('HOME');
            }
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <base href="<?php printSiteUri() ?>">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <!-- -----------------------------------
        |                                      |
        |   This is an onepaged website. So    |
        |   we need to canonize any URI into   |
        |   the home page. It is a base SEO    |
        |   requirement to prevent the home    |
        |   page copies on the SERP.           |
        |                                      |
        ------------------------------------ -->

        <link rel="canonical" href="<?php printSiteUri() ?>">

        <!-- -----------------------------------
        |                                      |
        |   Disable any Core's page to be      |
        |   indexed by searching robots        |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   Note: Remove following tag in your |
        |         modified version of this     |
        |         template. We use it for      |
        |         the DEMO purposes only.      |
        |                                      |
        ------------------------------------ -->

        <meta name="robots" content="noindex, nofollow">

        <!-- -----------------------------------
        |                                      |
        |   Meta information                   |
        |                                      |
        ------------------------------------ -->

        <title>
            Hello World
        </title>

        <meta name="description"
              content="It is a home page which demonstrate how this framework works.">

        <meta name="keywords"
              content="demo page, how framework works, hello world example">

        <!-- -----------------------------------
        |                                      |
        |   Your website icon                  |
        |                                      |
        ------------------------------------ -->

        <link rel="shortcut icon" href="<?php printSiteUri() ?>favicon.ico" type="image/ico">

        <!-- -----------------------------------
        |                                      |
        |   Insert the template's styles       |
        |                                      |
        ------------------------------------ -->

        <style>
            <?php mimimiDump('css/style.css', TRUE) ?>
        </style>
    </head>

    <!-- ---------------------------------------
    |                                          |
    |   Insert the template's SVG icons        |
    |                                          |
    ---------------------------------------- -->

    <body>
        <?php mimimiDump('images/icons.svg', TRUE) ?>

        <!-- -----------------------------------
        |                                      |
        |   The page header                    |
        |                                      |
        ------------------------------------ -->

        <header>
            <p>
                This is an example illustrating a simple application
                with European GDPR support.
            </p>
        </header>

        <!-- -----------------------------------
        |                                      |
        |   The page content                   |
        |                                      |
        ------------------------------------ -->

        <main>
            <h1>Hello World!</h1>

            <p>
                Welcome to the MiMiMi framework (version
                <em><?php echo MIMIMI_CORE_VERSION ?></em>).
                It is a lightweight software package for easy
                website development.
            </p>

            <p class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-license"></use>
                </svg>

                The package distributed under license
                <em>CreativeCommons CC&nbsp;BY&nbsp;4</em>.
                You are free to download and use this software
                for personal or commercial purposes.
            </p>

            <!-- -------------------------------
            |                                  |
            |   A remark                       |
            |                                  |
            -------------------------------- -->

            <blockquote class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-info"></use>
                </svg>

                If you are a developer, please see the
                <em><?php echo $folder ?>Application.php</em>
                file and its template
                <em><?php echo $folder . $filename ?></em>
                to understand how this framework works.
            </blockquote>

            <!-- -------------------------------
            |                                  |
            |   Pagination if you need         |
            |                                  |
            -------------------------------- -->

            <nav>
            </nav>

            <footer>
                Yours sincerely,<br>
                the MiMiMi author
            </footer>
        </main>

        <!-- -----------------------------------
        |                                      |
        |   The GDPR notice                    |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   Note: See the SCRIPT.JS file for   |
        |         the frontend handler for     |
        |         this block.                  |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   Note: The display of this block    |
        |         depends on the previous      |
        |         pressing of its button,      |
        |         which is stored in the       |
        |         session's parameter that     |
        |         named "noAnalysis".          |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   Note: See the HELPER.PHP file to   |
        |         understand this logic.       |
        |                                      |
        ------------------------------------ -->

        <?php
            if (!getSession('noAnalysis')) { ?>
                <aside>
                    <svg>
                        <use xlink:href="#icon-settings"></use>
                    </svg>

                    <div>
                        <strong>GDPR notice</strong>

                        Our website tracks the visitor's IP address, hostname, and
                        browser agent to inform our manager about the presence of
                        a live person on the website. This is the only element of
                        your personal data that we currently analyze. If you object
                        to this analysis, please click the button below.
                    </div>

                    <button>
                        Disable analysis
                    </button>
                </aside> <?php
            }
        ?>

        <!-- -----------------------------------
        |                                      |
        |   The page footer                    |
        |                                      |
        ------------------------------------ -->

        <footer>
            <p>&copy; <?php echo date('Y') ?> HelloWorld Example</p>
            <menu>
                <a href="https://mimimi.software/" rel="nofollow">Powered by MiMiMi</a>
                <a href="https://flaticon.com/" rel="nofollow">Icons by FlatIcon</a>
            </menu>
        </footer>

        <!-- -----------------------------------
        |                                      |
        |   Insert the template's javascripts  |
        |                                      |
        ------------------------------------ -->

        <script>
            <?php mimimiDump('js/script.js', TRUE) ?>
        </script>
    </body>
</html><?php

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;