<?php /* =======================================================
|                                                              |
|   MiMiMi Installer                                           |
|       Author: MiMiMi Community                               |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Load the default application from the CORE folder      |
    |                                                          |
    ========================================================= */

    mimimiInclude('Application.php');

    /* =========================================================
    |                                                          |
    |   Declare the child class                                |
    |                                                          |
    ========================================================= */

    class MyMimimiApplication extends MimimiApplication {

        /* =====================================================
        |                                                      |
        |   Perform some actions required to render a page     |
        |   with the current URI                               |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $params = MIXED = some parameters if you need  |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       MIXED = some result if you need                |
        |                                                      |
        ===================================================== */

        public function run ( $param = '' ) {
            $uri = mimimiUri(FALSE);
            $uri = strtolower($uri);

            /* ---------------------------------
            |                                  |
            |   Generate some HTML content by  |
            |   template of requested page     |
            |                                  |
            --------------------------------- */

            switch ($uri) {
                case '':
                    mimimiModule('home.php');
                    break;
                case 'step-1':
                case 'step-2':
                case 'step-3':
                case 'step-4':
                case 'step-5':
                case 'final':
                    mimimiModule($uri . '.php');
                    break;
                default:
                    mimimiModule('error404.php');
            }
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;