/* =============================================================
|                                                              |
|   MimimiCMS v.1.0                                            |
|       Author: MiMiMi Community                               |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   For example, let's add this file before website body:      |
|                                                              |
|       <script src="<?php theme() ?>js/cms.js"></script>      |
|       <script>                                               |
|           var cms = new MimimiCmsClass();                    |
|       </script>                                              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   For example, let's add some module to the CMS:             |
|                                                              |
|       <script>                                               |
|           cms.some = new SomeModuleClass();                  |
|       </script>                                              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   For example, let's request a pointer to this module:       |
|                                                              |
|       <script>                                               |
|           let module = cms.getModule('SomeModule');          |
|       </script>                                              |
|                                                              |
============================================================= */

    function MimimiCmsClass ( defaultBaseUri = '/' ) {

        /* =====================================================
        |                                                      |
        |   Declare the private properties                     |
        |                                                      |
        ===================================================== */

        var me          = this,
            defaultBase = defaultBaseUri,
            domain      = /^(https?:)?[\/\\][\/\\]+[^\/\\]+/i,
            absolute    = /^(https?:)?[\/\\]/i,
            lastNode    = /[\/\\]+[^\/\\]*$/,
            lastNodes   = /([\/\\]+[^\/\\]*){1,4}$/,
            urlOnly     = /^([^?#]*)[?#].*$/,
            moduleURIs  = [];

        /* =====================================================
        |                                                      |
        |   Get the URI-path of a provided URI                 |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Note: The URI-path is a URI without a domain or    |
        |         filename. There is also a trailing slash.    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       uri = STRING = provided URI                    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       STRING = resolved path                         |
        |                                                      |
        ===================================================== */

        me.getUriPath = function ( uri ) {
            uri = uri.replace(urlOnly, '$1');
            uri = uri.replace(domain, '');
            uri = uri.replace(lastNode, '/');
            return uri == ''
                   ? '/'
                   : uri;
        };

        /* =====================================================
        |                                                      |
        |   Store the provided URI of a specific module        |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       name = STRING = name of the module             |
        |       uri  = STRING = provided URI                   |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       NONE                                           |
        |                                                      |
        ===================================================== */

        me.storeModuleUri = function ( name, uri ) {
            moduleURIs[name] = uri;
        };

        /* =====================================================
        |                                                      |
        |   Get the stored URI for a specific module           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       name = STRING = name of the module             |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       STRING = resolved URI                          |
        |                                                      |
        ===================================================== */

        me.getModuleUri = function ( name ) {
            return typeof moduleURIs[name] == 'undefined'
                   ? ''
                   : moduleURIs[name];
        };

        /* =====================================================
        |                                                      |
        |   Get the base URI for a specific module API         |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Note: This URI is absolute. There is also          |
        |         a trailing slash.                            |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       name = STRING = name of the module             |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       STRING = resolved URI                          |
        |                                                      |
        ===================================================== */

        me.getModuleBase = function ( name ) {
            let moduleUri = me.getModuleUri(name);
            if (moduleUri == '') {
                return defaultBase;
            } else if (!moduleUri.match(absolute)) {
                let pageUri = document.location.href;
                moduleUri = me.getUriPath(pageUri) +
                            moduleUri;
            }
            moduleUri = moduleUri.replace(urlOnly, '$1');
            return moduleUri.replace(lastNodes, '/');
        };

        /* =====================================================
        |                                                      |
        |   Get the requested module                           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       name = STRING = name of the module             |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       OBJECT = if that module exists                 |
        |       NULL   = if it is absent                       |
        |                                                      |
        ===================================================== */

        me.getModule = function ( name ) {
            for (let key in me) {
                if (typeof me[key] == 'object') {
                    if ('name' in me[key]) {
                        if (me[key].name == name) {
                            return me[key];
                        }
                    }
                }
            }
            return null;
        };
    };
