<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Core's home page            |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = Core's folder name (ended with slash)      |
|       $filename = this template filepath (relative to the    |
|                   Core's folder)                             |
|       $file     = this template's absolute filepath          |
|       $cms      = Core's application object                  |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some server-side actions            |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    ----------------------------------------- */

    mimimiInclude('Theme/helper.php');
    helperSession();

    /* -----------------------------------------
    |                                          |
    |   Make a content for the user            |
    |                                          |
    ----------------------------------------- */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="canonical" href="/<?php mimimiRoot() ?>">

        <!-- -----------------------------------
        |                                      |
        |   Meta information                   |
        |                                      |
        ------------------------------------ -->

        <title>
            Hello World
        </title>

        <meta name="description"
              content="It is a home page which demonstrate how this framework works.">

        <meta name="keywords"
              content="demo page, how framework works, hello world example">

        <!-- -----------------------------------
        |                                      |
        |   Disable any Core's page to be      |
        |   indexed by searching robots        |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   Note: Remove following tag in your |
        |         modified version of this     |
        |         template. We use it for      |
        |         the DEMO purposes only.      |
        |                                      |
        ------------------------------------ -->

        <meta name="robots" content="noindex, nofollow">

        <!-- ===================================================
        |                                                      |
        |   Insert the template's styles                       |
        |                                                      |
        ==================================================== -->

        <style>
            <?php mimimiDump('Theme/style.css', TRUE) ?>
        </style>
    </head>

    <!-- =======================================================
    |                                                          |
    |   Insert the template's SVG icons                        |
    |                                                          |
    ======================================================== -->

    <body>
        <?php mimimiDump('Theme/icons.svg', TRUE) ?>

        <!-- ===================================================
        |                                                      |
        |   The page header                                    |
        |                                                      |
        ==================================================== -->

        <header class="header">
        </header>

        <!-- ===================================================
        |                                                      |
        |   The page content                                   |
        |                                                      |
        ==================================================== -->

        <main class="content hanging">
            <h1 class="title">
                Hello World!
            </h1>

            <p>
                Welcome to the MiMiMi framework (version
                <em><?php echo MIMIMI_CORE_VERSION ?></em>).
                It is a lightweight software package for easy
                website development.
            </p>

            <p class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-license"></use>
                </svg>

                The package distributed under license
                <em>CreativeCommons CC&nbsp;BY&nbsp;4</em>.
                You are free to download and use this software
                for personal or commercial purposes.
            </p>

            <blockquote class="note iconized">
                <svg class="icon">
                    <use xlink:href="#icon-info"></use>
                </svg>

                If you are a developer, please see the
                <em><?php echo MIMIMI_CORE_FOLDER ?>Application.php</em>
                file and its template
                <em><?php echo MIMIMI_CORE_FOLDER ?>Theme/home.php</em>
                to understand how this framework works.
            </blockquote>

            <nav class="pagination">
            </nav>

            <div class="copyright">
                Yours sincerely, <br> the MiMiMi author
            </div>
        </main>

        <!-- ===================================================
        |                                                      |
        |   The page footer                                    |
        |                                                      |
        ==================================================== -->

        <footer class="footer">
        </footer>

        <!-- ===================================================
        |                                                      |
        |   Insert the template's javascripts                  |
        |                                                      |
        ==================================================== -->

        <script>
            <?php mimimiDump('Theme/script.js', TRUE) ?>
        </script>
    </body>
</html><?php

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;