<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is a class for the default application. It is    |
|   the simplest controller (in MVP terminology) and it        |
|   contains a minimum of methods for working with your        |
|   application.                                               |
|                                                              |
|   You must extend this class in your modified version        |
|   of the framework to get a specific type of CMS.            |
|   To do this, look up the RUN() method below and rewrite     |
|   it in that extended class.                                 |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Check for the existence of main constants              |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: This action is an insurance mechanism. It is     |
    |         used to make your application work without       |
    |         errors. You can remove this action if you are    |
    |         sure to preserve the integrity of your CMS file  |
    |         composition.                                     |
    |                                                          |
    ========================================================= */

    mimimiCheck();

    /* =========================================================
    |                                                          |
    |   Define the default application class                   |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: If you modify the framework files, they must     |
    |         be located in a specific folder for the modified |
    |         version (see constant MIMIMI_CMS_FOLDER).        |
    |         And the modified classes must be prefixed with   |
    |         "My". For example MyMimimiApplication.           |
    |                                                          |
    ========================================================= */

    class MimimiApplication {
        protected $cms;

        /* =====================================================
        |                                                      |
        |   Create an instance of the class                    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $owner = OBJECT = a parent application         |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       NONE                                           |
        |                                                      |
        ===================================================== */

        public function __construct ( & $owner = NULL ) {
            $this->cms = $owner
                         ? $owner
                         : $this;
        }

        /* =====================================================
        |                                                      |
        |   Load related module into absent property           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $property = STRING = name of property          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       OBJECT = created module                        |
        |                                                      |
        ===================================================== */

        public function __get ( $property ) {
            return mimimiCreate($property, $this);
        }

        /* =====================================================
        |                                                      |
        |   Perform the necessary operations for the page      |
        |   with the current URI                               |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       NONE                                           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       NONE                                           |
        |                                                      |
        ===================================================== */

        public function run () {
            echo 'Hello World!';
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;