<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is the starting point of your website. It just   |
|   loads the default application or its modified version      |
|   and launches that application.                             |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Define some constants                                  |
    |       > the official version of the framework            |
    |       > where the framework is located                   |
    |       > where is its modified version                    |
    |                                                          |
    ========================================================= */

    define('MIMIMI_CORE_VERSION', '1.0 - 2022.01.11');
    define('MIMIMI_CORE_FOLDER',  'mimimi.core/');
    define('MIMIMI_CMS_FOLDER',   'mimimi.cms/');

    /* =========================================================
    |                                                          |
    |   Launch the application                                 |
    |       > from which folder the routines are needed        |
    |       > load mini helper routines:                       |
    |             mimimiCreate = create the required object    |
    |             mimimiStop   = stop execution                |
    |             mimimiCheck  = check for constants existence |
    |       > load and create an app (it will become your CMS) |
    |       > run it                                           |
    |                                                          |
    ========================================================= */

    $dir = MIMIMI_CORE_FOLDER;
    require_once($dir . 'Routines.php');
    $cms = mimimiCreate('application');
    $cms->run();

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;